package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.NodeAddress;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineStatusFluent<A extends MachineStatusFluent<A>> extends BaseFluent<A>{
  public MachineStatusFluent() {
  }
  
  public MachineStatusFluent(MachineStatus instance) {
    this.copyInstance(instance);
  }
  private List<NodeAddress> addresses = new ArrayList<NodeAddress>();
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private String errorMessage;
  private String errorReason;
  private LastOperationBuilder lastOperation;
  private String lastUpdated;
  private ObjectReferenceBuilder nodeRef;
  private String phase;
  private Map<String,Object> providerStatus;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineStatus instance) {
    instance = (instance != null ? instance : new MachineStatus());
  
    if (instance != null) {
        this.withAddresses(instance.getAddresses());
        this.withConditions(instance.getConditions());
        this.withErrorMessage(instance.getErrorMessage());
        this.withErrorReason(instance.getErrorReason());
        this.withLastOperation(instance.getLastOperation());
        this.withLastUpdated(instance.getLastUpdated());
        this.withNodeRef(instance.getNodeRef());
        this.withPhase(instance.getPhase());
        this.withProviderStatus(instance.getProviderStatus());
        this.withAddresses(instance.getAddresses());
        this.withConditions(instance.getConditions());
        this.withErrorMessage(instance.getErrorMessage());
        this.withErrorReason(instance.getErrorReason());
        this.withLastOperation(instance.getLastOperation());
        this.withLastUpdated(instance.getLastUpdated());
        this.withNodeRef(instance.getNodeRef());
        this.withPhase(instance.getPhase());
        this.withProviderStatus(instance.getProviderStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToAddresses(int index,NodeAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<NodeAddress>();}
    this.addresses.add(index, item);
    return (A)this;
  }
  
  public A setToAddresses(int index,NodeAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<NodeAddress>();}
    this.addresses.set(index, item); return (A)this;
  }
  
  public A addToAddresses(io.fabric8.kubernetes.api.model.NodeAddress... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<NodeAddress>();}
    for (NodeAddress item : items) {this.addresses.add(item);} return (A)this;
  }
  
  public A addAllToAddresses(Collection<NodeAddress> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<NodeAddress>();}
    for (NodeAddress item : items) {this.addresses.add(item);} return (A)this;
  }
  
  public A removeFromAddresses(io.fabric8.kubernetes.api.model.NodeAddress... items) {
    if (this.addresses == null) return (A)this;
    for (NodeAddress item : items) { this.addresses.remove(item);} return (A)this;
  }
  
  public A removeAllFromAddresses(Collection<NodeAddress> items) {
    if (this.addresses == null) return (A)this;
    for (NodeAddress item : items) { this.addresses.remove(item);} return (A)this;
  }
  
  public List<NodeAddress> getAddresses() {
    return this.addresses;
  }
  
  public NodeAddress getAddress(int index) {
    return this.addresses.get(index);
  }
  
  public NodeAddress getFirstAddress() {
    return this.addresses.get(0);
  }
  
  public NodeAddress getLastAddress() {
    return this.addresses.get(addresses.size() - 1);
  }
  
  public NodeAddress getMatchingAddress(Predicate<NodeAddress> predicate) {
    for (NodeAddress item: addresses) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingAddress(Predicate<NodeAddress> predicate) {
    for (NodeAddress item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withAddresses(List<NodeAddress> addresses) {
    if (addresses != null) {this.addresses = new ArrayList(); for (NodeAddress item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  
  public A withAddresses(io.fabric8.kubernetes.api.model.NodeAddress... addresses) {
    if (this.addresses != null) {this.addresses.clear(); _visitables.remove("addresses"); }
    if (addresses != null) {for (NodeAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  
  public boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  
  public A addNewAddress(String address,String type) {
    return (A)addToAddresses(new NodeAddress(address, type));
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.openshift.api.model.machine.v1beta1.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.openshift.api.model.machine.v1beta1.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  
  public Condition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  
  public A withConditions(io.fabric8.openshift.api.model.machine.v1beta1.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(Condition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,Condition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public String getErrorMessage() {
    return this.errorMessage;
  }
  
  public A withErrorMessage(String errorMessage) {
    this.errorMessage=errorMessage; return (A) this;
  }
  
  public boolean hasErrorMessage() {
    return this.errorMessage != null;
  }
  
  public String getErrorReason() {
    return this.errorReason;
  }
  
  public A withErrorReason(String errorReason) {
    this.errorReason=errorReason; return (A) this;
  }
  
  public boolean hasErrorReason() {
    return this.errorReason != null;
  }
  
  public LastOperation buildLastOperation() {
    return this.lastOperation!=null ?this.lastOperation.build():null;
  }
  
  public A withLastOperation(LastOperation lastOperation) {
    _visitables.get("lastOperation").remove(this.lastOperation);
    if (lastOperation!=null){ this.lastOperation= new LastOperationBuilder(lastOperation); _visitables.get("lastOperation").add(this.lastOperation);} else { this.lastOperation = null; _visitables.get("lastOperation").remove(this.lastOperation); } return (A) this;
  }
  
  public boolean hasLastOperation() {
    return this.lastOperation != null;
  }
  
  public A withNewLastOperation(String description,String lastUpdated,String state,String type) {
    return (A)withLastOperation(new LastOperation(description, lastUpdated, state, type));
  }
  
  public LastOperationNested<A> withNewLastOperation() {
    return new LastOperationNested(null);
  }
  
  public LastOperationNested<A> withNewLastOperationLike(LastOperation item) {
    return new LastOperationNested(item);
  }
  
  public LastOperationNested<A> editLastOperation() {
    return withNewLastOperationLike(java.util.Optional.ofNullable(buildLastOperation()).orElse(null));
  }
  
  public LastOperationNested<A> editOrNewLastOperation() {
    return withNewLastOperationLike(java.util.Optional.ofNullable(buildLastOperation()).orElse(new LastOperationBuilder().build()));
  }
  
  public LastOperationNested<A> editOrNewLastOperationLike(LastOperation item) {
    return withNewLastOperationLike(java.util.Optional.ofNullable(buildLastOperation()).orElse(item));
  }
  
  public String getLastUpdated() {
    return this.lastUpdated;
  }
  
  public A withLastUpdated(String lastUpdated) {
    this.lastUpdated=lastUpdated; return (A) this;
  }
  
  public boolean hasLastUpdated() {
    return this.lastUpdated != null;
  }
  
  public ObjectReference buildNodeRef() {
    return this.nodeRef!=null ?this.nodeRef.build():null;
  }
  
  public A withNodeRef(ObjectReference nodeRef) {
    _visitables.get("nodeRef").remove(this.nodeRef);
    if (nodeRef!=null){ this.nodeRef= new ObjectReferenceBuilder(nodeRef); _visitables.get("nodeRef").add(this.nodeRef);} else { this.nodeRef = null; _visitables.get("nodeRef").remove(this.nodeRef); } return (A) this;
  }
  
  public boolean hasNodeRef() {
    return this.nodeRef != null;
  }
  
  public NodeRefNested<A> withNewNodeRef() {
    return new NodeRefNested(null);
  }
  
  public NodeRefNested<A> withNewNodeRefLike(ObjectReference item) {
    return new NodeRefNested(item);
  }
  
  public NodeRefNested<A> editNodeRef() {
    return withNewNodeRefLike(java.util.Optional.ofNullable(buildNodeRef()).orElse(null));
  }
  
  public NodeRefNested<A> editOrNewNodeRef() {
    return withNewNodeRefLike(java.util.Optional.ofNullable(buildNodeRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public NodeRefNested<A> editOrNewNodeRefLike(ObjectReference item) {
    return withNewNodeRefLike(java.util.Optional.ofNullable(buildNodeRef()).orElse(item));
  }
  
  public String getPhase() {
    return this.phase;
  }
  
  public A withPhase(String phase) {
    this.phase=phase; return (A) this;
  }
  
  public boolean hasPhase() {
    return this.phase != null;
  }
  
  public A addToProviderStatus(String key,Object value) {
    if(this.providerStatus == null && key != null && value != null) { this.providerStatus = new LinkedHashMap(); }
    if(key != null && value != null) {this.providerStatus.put(key, value);} return (A)this;
  }
  
  public A addToProviderStatus(Map<String,Object> map) {
    if(this.providerStatus == null && map != null) { this.providerStatus = new LinkedHashMap(); }
    if(map != null) { this.providerStatus.putAll(map);} return (A)this;
  }
  
  public A removeFromProviderStatus(String key) {
    if(this.providerStatus == null) { return (A) this; }
    if(key != null && this.providerStatus != null) {this.providerStatus.remove(key);} return (A)this;
  }
  
  public A removeFromProviderStatus(Map<String,Object> map) {
    if(this.providerStatus == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.providerStatus != null){this.providerStatus.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getProviderStatus() {
    return this.providerStatus;
  }
  
  public <K,V>A withProviderStatus(Map<String,Object> providerStatus) {
    if (providerStatus == null) { this.providerStatus =  null;} else {this.providerStatus = new LinkedHashMap(providerStatus);} return (A) this;
  }
  
  public boolean hasProviderStatus() {
    return this.providerStatus != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineStatusFluent that = (MachineStatusFluent) o;
    if (!java.util.Objects.equals(addresses, that.addresses)) return false;
  
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
  
    if (!java.util.Objects.equals(errorMessage, that.errorMessage)) return false;
  
    if (!java.util.Objects.equals(errorReason, that.errorReason)) return false;
  
    if (!java.util.Objects.equals(lastOperation, that.lastOperation)) return false;
  
    if (!java.util.Objects.equals(lastUpdated, that.lastUpdated)) return false;
  
    if (!java.util.Objects.equals(nodeRef, that.nodeRef)) return false;
  
    if (!java.util.Objects.equals(phase, that.phase)) return false;
  
    if (!java.util.Objects.equals(providerStatus, that.providerStatus)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(addresses,  conditions,  errorMessage,  errorReason,  lastOperation,  lastUpdated,  nodeRef,  phase,  providerStatus,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (errorMessage != null) { sb.append("errorMessage:"); sb.append(errorMessage + ","); }
    if (errorReason != null) { sb.append("errorReason:"); sb.append(errorReason + ","); }
    if (lastOperation != null) { sb.append("lastOperation:"); sb.append(lastOperation + ","); }
    if (lastUpdated != null) { sb.append("lastUpdated:"); sb.append(lastUpdated + ","); }
    if (nodeRef != null) { sb.append("nodeRef:"); sb.append(nodeRef + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (providerStatus != null && !providerStatus.isEmpty()) { sb.append("providerStatus:"); sb.append(providerStatus + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends ConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) MachineStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class LastOperationNested<N> extends LastOperationFluent<LastOperationNested<N>> implements Nested<N>{
    LastOperationNested(LastOperation item) {
      this.builder = new LastOperationBuilder(this, item);
    }
    LastOperationBuilder builder;
    
    public N and() {
      return (N) MachineStatusFluent.this.withLastOperation(builder.build());
    }
    
    public N endLastOperation() {
      return and();
    }
    
  
  }
  public class NodeRefNested<N> extends ObjectReferenceFluent<NodeRefNested<N>> implements Nested<N>{
    NodeRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) MachineStatusFluent.this.withNodeRef(builder.build());
    }
    
    public N endNodeRef() {
      return and();
    }
    
  
  }

}