package io.fabric8.openshift.api.model.machine.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ControlPlaneMachineSetSpecFluent<A extends ControlPlaneMachineSetSpecFluent<A>> extends BaseFluent<A>{
  public ControlPlaneMachineSetSpecFluent() {
  }
  
  public ControlPlaneMachineSetSpecFluent(ControlPlaneMachineSetSpec instance) {
    this.copyInstance(instance);
  }
  private Integer replicas;
  private LabelSelectorBuilder selector;
  private String state;
  private ControlPlaneMachineSetStrategyBuilder strategy;
  private ControlPlaneMachineSetTemplateBuilder template;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ControlPlaneMachineSetSpec instance) {
    instance = (instance != null ? instance : new ControlPlaneMachineSetSpec());
    if (instance != null) {
          this.withReplicas(instance.getReplicas());
          this.withSelector(instance.getSelector());
          this.withState(instance.getState());
          this.withStrategy(instance.getStrategy());
          this.withTemplate(instance.getTemplate());
          this.withReplicas(instance.getReplicas());
          this.withSelector(instance.getSelector());
          this.withState(instance.getState());
          this.withStrategy(instance.getStrategy());
          this.withTemplate(instance.getTemplate());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getReplicas() {
    return this.replicas;
  }
  
  public A withReplicas(Integer replicas) {
    this.replicas = replicas;
    return (A) this;
  }
  
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  
  public LabelSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(LabelSelector selector) {
    this._visitables.remove(this.selector);
    if (selector != null) {
        this.selector = new LabelSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public String getState() {
    return this.state;
  }
  
  public A withState(String state) {
    this.state = state;
    return (A) this;
  }
  
  public boolean hasState() {
    return this.state != null;
  }
  
  public ControlPlaneMachineSetStrategy buildStrategy() {
    return this.strategy != null ? this.strategy.build() : null;
  }
  
  public A withStrategy(ControlPlaneMachineSetStrategy strategy) {
    this._visitables.remove(this.strategy);
    if (strategy != null) {
        this.strategy = new ControlPlaneMachineSetStrategyBuilder(strategy);
        this._visitables.get("strategy").add(this.strategy);
    } else {
        this.strategy = null;
        this._visitables.get("strategy").remove(this.strategy);
    }
    return (A) this;
  }
  
  public boolean hasStrategy() {
    return this.strategy != null;
  }
  
  public A withNewStrategy(String type) {
    return (A)withStrategy(new ControlPlaneMachineSetStrategy(type));
  }
  
  public StrategyNested<A> withNewStrategy() {
    return new StrategyNested(null);
  }
  
  public StrategyNested<A> withNewStrategyLike(ControlPlaneMachineSetStrategy item) {
    return new StrategyNested(item);
  }
  
  public StrategyNested<A> editStrategy() {
    return withNewStrategyLike(java.util.Optional.ofNullable(buildStrategy()).orElse(null));
  }
  
  public StrategyNested<A> editOrNewStrategy() {
    return withNewStrategyLike(java.util.Optional.ofNullable(buildStrategy()).orElse(new ControlPlaneMachineSetStrategyBuilder().build()));
  }
  
  public StrategyNested<A> editOrNewStrategyLike(ControlPlaneMachineSetStrategy item) {
    return withNewStrategyLike(java.util.Optional.ofNullable(buildStrategy()).orElse(item));
  }
  
  public ControlPlaneMachineSetTemplate buildTemplate() {
    return this.template != null ? this.template.build() : null;
  }
  
  public A withTemplate(ControlPlaneMachineSetTemplate template) {
    this._visitables.remove(this.template);
    if (template != null) {
        this.template = new ControlPlaneMachineSetTemplateBuilder(template);
        this._visitables.get("template").add(this.template);
    } else {
        this.template = null;
        this._visitables.get("template").remove(this.template);
    }
    return (A) this;
  }
  
  public boolean hasTemplate() {
    return this.template != null;
  }
  
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  
  public TemplateNested<A> withNewTemplateLike(ControlPlaneMachineSetTemplate item) {
    return new TemplateNested(item);
  }
  
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new ControlPlaneMachineSetTemplateBuilder().build()));
  }
  
  public TemplateNested<A> editOrNewTemplateLike(ControlPlaneMachineSetTemplate item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ControlPlaneMachineSetSpecFluent that = (ControlPlaneMachineSetSpecFluent) o;
    if (!java.util.Objects.equals(replicas, that.replicas)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(state, that.state)) return false;
    if (!java.util.Objects.equals(strategy, that.strategy)) return false;
    if (!java.util.Objects.equals(template, that.template)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(replicas,  selector,  state,  strategy,  template,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ControlPlaneMachineSetSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }
  public class StrategyNested<N> extends ControlPlaneMachineSetStrategyFluent<StrategyNested<N>> implements Nested<N>{
    StrategyNested(ControlPlaneMachineSetStrategy item) {
      this.builder = new ControlPlaneMachineSetStrategyBuilder(this, item);
    }
    ControlPlaneMachineSetStrategyBuilder builder;
    
    public N and() {
      return (N) ControlPlaneMachineSetSpecFluent.this.withStrategy(builder.build());
    }
    
    public N endStrategy() {
      return and();
    }
    
  
  }
  public class TemplateNested<N> extends ControlPlaneMachineSetTemplateFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(ControlPlaneMachineSetTemplate item) {
      this.builder = new ControlPlaneMachineSetTemplateBuilder(this, item);
    }
    ControlPlaneMachineSetTemplateBuilder builder;
    
    public N and() {
      return (N) ControlPlaneMachineSetSpecFluent.this.withTemplate(builder.build());
    }
    
    public N endTemplate() {
      return and();
    }
    
  
  }

}