package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class FailureDomainsFluent<A extends FailureDomainsFluent<A>> extends BaseFluent<A>{
  public FailureDomainsFluent() {
  }
  
  public FailureDomainsFluent(FailureDomains instance) {
    this.copyInstance(instance);
  }
  private ArrayList<AWSFailureDomainBuilder> aws = new ArrayList<AWSFailureDomainBuilder>();
  private ArrayList<AzureFailureDomainBuilder> azure = new ArrayList<AzureFailureDomainBuilder>();
  private ArrayList<GCPFailureDomainBuilder> gcp = new ArrayList<GCPFailureDomainBuilder>();
  private ArrayList<OpenStackFailureDomainBuilder> openstack = new ArrayList<OpenStackFailureDomainBuilder>();
  private String platform;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(FailureDomains instance) {
    instance = (instance != null ? instance : new FailureDomains());
    if (instance != null) {
          this.withAws(instance.getAws());
          this.withAzure(instance.getAzure());
          this.withGcp(instance.getGcp());
          this.withOpenstack(instance.getOpenstack());
          this.withPlatform(instance.getPlatform());
          this.withAws(instance.getAws());
          this.withAzure(instance.getAzure());
          this.withGcp(instance.getGcp());
          this.withOpenstack(instance.getOpenstack());
          this.withPlatform(instance.getPlatform());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAws(int index,AWSFailureDomain item) {
    if (this.aws == null) {this.aws = new ArrayList<AWSFailureDomainBuilder>();}
    AWSFailureDomainBuilder builder = new AWSFailureDomainBuilder(item);
    if (index < 0 || index >= aws.size()) { _visitables.get("aws").add(builder); aws.add(builder); } else { _visitables.get("aws").add(index, builder); aws.add(index, builder);}
    return (A)this;
  }
  
  public A setToAws(int index,AWSFailureDomain item) {
    if (this.aws == null) {this.aws = new ArrayList<AWSFailureDomainBuilder>();}
    AWSFailureDomainBuilder builder = new AWSFailureDomainBuilder(item);
    if (index < 0 || index >= aws.size()) { _visitables.get("aws").add(builder); aws.add(builder); } else { _visitables.get("aws").set(index, builder); aws.set(index, builder);}
    return (A)this;
  }
  
  public A addToAws(io.fabric8.openshift.api.model.machine.v1.AWSFailureDomain... items) {
    if (this.aws == null) {this.aws = new ArrayList<AWSFailureDomainBuilder>();}
    for (AWSFailureDomain item : items) {AWSFailureDomainBuilder builder = new AWSFailureDomainBuilder(item);_visitables.get("aws").add(builder);this.aws.add(builder);} return (A)this;
  }
  
  public A addAllToAws(Collection<AWSFailureDomain> items) {
    if (this.aws == null) {this.aws = new ArrayList<AWSFailureDomainBuilder>();}
    for (AWSFailureDomain item : items) {AWSFailureDomainBuilder builder = new AWSFailureDomainBuilder(item);_visitables.get("aws").add(builder);this.aws.add(builder);} return (A)this;
  }
  
  public A removeFromAws(io.fabric8.openshift.api.model.machine.v1.AWSFailureDomain... items) {
    if (this.aws == null) return (A)this;
    for (AWSFailureDomain item : items) {AWSFailureDomainBuilder builder = new AWSFailureDomainBuilder(item);_visitables.get("aws").remove(builder); this.aws.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAws(Collection<AWSFailureDomain> items) {
    if (this.aws == null) return (A)this;
    for (AWSFailureDomain item : items) {AWSFailureDomainBuilder builder = new AWSFailureDomainBuilder(item);_visitables.get("aws").remove(builder); this.aws.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAws(Predicate<AWSFailureDomainBuilder> predicate) {
    if (aws == null) return (A) this;
    final Iterator<AWSFailureDomainBuilder> each = aws.iterator();
    final List visitables = _visitables.get("aws");
    while (each.hasNext()) {
      AWSFailureDomainBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AWSFailureDomain> buildAws() {
    return this.aws != null ? build(aws) : null;
  }
  
  public AWSFailureDomain buildAw(int index) {
    return this.aws.get(index).build();
  }
  
  public AWSFailureDomain buildFirstAw() {
    return this.aws.get(0).build();
  }
  
  public AWSFailureDomain buildLastAw() {
    return this.aws.get(aws.size() - 1).build();
  }
  
  public AWSFailureDomain buildMatchingAw(Predicate<AWSFailureDomainBuilder> predicate) {
      for (AWSFailureDomainBuilder item : aws) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAw(Predicate<AWSFailureDomainBuilder> predicate) {
      for (AWSFailureDomainBuilder item : aws) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAws(List<AWSFailureDomain> aws) {
    if (this.aws != null) {
      this._visitables.get("aws").clear();
    }
    if (aws != null) {
        this.aws = new ArrayList();
        for (AWSFailureDomain item : aws) {
          this.addToAws(item);
        }
    } else {
      this.aws = null;
    }
    return (A) this;
  }
  
  public A withAws(io.fabric8.openshift.api.model.machine.v1.AWSFailureDomain... aws) {
    if (this.aws != null) {this.aws.clear(); _visitables.remove("aws"); }
    if (aws != null) {for (AWSFailureDomain item :aws){ this.addToAws(item);}} return (A) this;
  }
  
  public boolean hasAws() {
    return this.aws != null && !this.aws.isEmpty();
  }
  
  public AwsNested<A> addNewAw() {
    return new AwsNested(-1, null);
  }
  
  public AwsNested<A> addNewAwLike(AWSFailureDomain item) {
    return new AwsNested(-1, item);
  }
  
  public AwsNested<A> setNewAwLike(int index,AWSFailureDomain item) {
    return new AwsNested(index, item);
  }
  
  public AwsNested<A> editAw(int index) {
    if (aws.size() <= index) throw new RuntimeException("Can't edit aws. Index exceeds size.");
    return setNewAwLike(index, buildAw(index));
  }
  
  public AwsNested<A> editFirstAw() {
    if (aws.size() == 0) throw new RuntimeException("Can't edit first aws. The list is empty.");
    return setNewAwLike(0, buildAw(0));
  }
  
  public AwsNested<A> editLastAw() {
    int index = aws.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last aws. The list is empty.");
    return setNewAwLike(index, buildAw(index));
  }
  
  public AwsNested<A> editMatchingAw(Predicate<AWSFailureDomainBuilder> predicate) {
    int index = -1;
    for (int i=0;i<aws.size();i++) { 
    if (predicate.test(aws.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching aws. No match found.");
    return setNewAwLike(index, buildAw(index));
  }
  
  public A addToAzure(int index,AzureFailureDomain item) {
    if (this.azure == null) {this.azure = new ArrayList<AzureFailureDomainBuilder>();}
    AzureFailureDomainBuilder builder = new AzureFailureDomainBuilder(item);
    if (index < 0 || index >= azure.size()) { _visitables.get("azure").add(builder); azure.add(builder); } else { _visitables.get("azure").add(index, builder); azure.add(index, builder);}
    return (A)this;
  }
  
  public A setToAzure(int index,AzureFailureDomain item) {
    if (this.azure == null) {this.azure = new ArrayList<AzureFailureDomainBuilder>();}
    AzureFailureDomainBuilder builder = new AzureFailureDomainBuilder(item);
    if (index < 0 || index >= azure.size()) { _visitables.get("azure").add(builder); azure.add(builder); } else { _visitables.get("azure").set(index, builder); azure.set(index, builder);}
    return (A)this;
  }
  
  public A addToAzure(io.fabric8.openshift.api.model.machine.v1.AzureFailureDomain... items) {
    if (this.azure == null) {this.azure = new ArrayList<AzureFailureDomainBuilder>();}
    for (AzureFailureDomain item : items) {AzureFailureDomainBuilder builder = new AzureFailureDomainBuilder(item);_visitables.get("azure").add(builder);this.azure.add(builder);} return (A)this;
  }
  
  public A addAllToAzure(Collection<AzureFailureDomain> items) {
    if (this.azure == null) {this.azure = new ArrayList<AzureFailureDomainBuilder>();}
    for (AzureFailureDomain item : items) {AzureFailureDomainBuilder builder = new AzureFailureDomainBuilder(item);_visitables.get("azure").add(builder);this.azure.add(builder);} return (A)this;
  }
  
  public A removeFromAzure(io.fabric8.openshift.api.model.machine.v1.AzureFailureDomain... items) {
    if (this.azure == null) return (A)this;
    for (AzureFailureDomain item : items) {AzureFailureDomainBuilder builder = new AzureFailureDomainBuilder(item);_visitables.get("azure").remove(builder); this.azure.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAzure(Collection<AzureFailureDomain> items) {
    if (this.azure == null) return (A)this;
    for (AzureFailureDomain item : items) {AzureFailureDomainBuilder builder = new AzureFailureDomainBuilder(item);_visitables.get("azure").remove(builder); this.azure.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAzure(Predicate<AzureFailureDomainBuilder> predicate) {
    if (azure == null) return (A) this;
    final Iterator<AzureFailureDomainBuilder> each = azure.iterator();
    final List visitables = _visitables.get("azure");
    while (each.hasNext()) {
      AzureFailureDomainBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AzureFailureDomain> buildAzure() {
    return this.azure != null ? build(azure) : null;
  }
  
  public AzureFailureDomain buildAzure(int index) {
    return this.azure.get(index).build();
  }
  
  public AzureFailureDomain buildFirstAzure() {
    return this.azure.get(0).build();
  }
  
  public AzureFailureDomain buildLastAzure() {
    return this.azure.get(azure.size() - 1).build();
  }
  
  public AzureFailureDomain buildMatchingAzure(Predicate<AzureFailureDomainBuilder> predicate) {
      for (AzureFailureDomainBuilder item : azure) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAzure(Predicate<AzureFailureDomainBuilder> predicate) {
      for (AzureFailureDomainBuilder item : azure) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAzure(List<AzureFailureDomain> azure) {
    if (this.azure != null) {
      this._visitables.get("azure").clear();
    }
    if (azure != null) {
        this.azure = new ArrayList();
        for (AzureFailureDomain item : azure) {
          this.addToAzure(item);
        }
    } else {
      this.azure = null;
    }
    return (A) this;
  }
  
  public A withAzure(io.fabric8.openshift.api.model.machine.v1.AzureFailureDomain... azure) {
    if (this.azure != null) {this.azure.clear(); _visitables.remove("azure"); }
    if (azure != null) {for (AzureFailureDomain item :azure){ this.addToAzure(item);}} return (A) this;
  }
  
  public boolean hasAzure() {
    return this.azure != null && !this.azure.isEmpty();
  }
  
  public A addNewAzure(String zone) {
    return (A)addToAzure(new AzureFailureDomain(zone));
  }
  
  public AzureNested<A> addNewAzure() {
    return new AzureNested(-1, null);
  }
  
  public AzureNested<A> addNewAzureLike(AzureFailureDomain item) {
    return new AzureNested(-1, item);
  }
  
  public AzureNested<A> setNewAzureLike(int index,AzureFailureDomain item) {
    return new AzureNested(index, item);
  }
  
  public AzureNested<A> editAzure(int index) {
    if (azure.size() <= index) throw new RuntimeException("Can't edit azure. Index exceeds size.");
    return setNewAzureLike(index, buildAzure(index));
  }
  
  public AzureNested<A> editFirstAzure() {
    if (azure.size() == 0) throw new RuntimeException("Can't edit first azure. The list is empty.");
    return setNewAzureLike(0, buildAzure(0));
  }
  
  public AzureNested<A> editLastAzure() {
    int index = azure.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last azure. The list is empty.");
    return setNewAzureLike(index, buildAzure(index));
  }
  
  public AzureNested<A> editMatchingAzure(Predicate<AzureFailureDomainBuilder> predicate) {
    int index = -1;
    for (int i=0;i<azure.size();i++) { 
    if (predicate.test(azure.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching azure. No match found.");
    return setNewAzureLike(index, buildAzure(index));
  }
  
  public A addToGcp(int index,GCPFailureDomain item) {
    if (this.gcp == null) {this.gcp = new ArrayList<GCPFailureDomainBuilder>();}
    GCPFailureDomainBuilder builder = new GCPFailureDomainBuilder(item);
    if (index < 0 || index >= gcp.size()) { _visitables.get("gcp").add(builder); gcp.add(builder); } else { _visitables.get("gcp").add(index, builder); gcp.add(index, builder);}
    return (A)this;
  }
  
  public A setToGcp(int index,GCPFailureDomain item) {
    if (this.gcp == null) {this.gcp = new ArrayList<GCPFailureDomainBuilder>();}
    GCPFailureDomainBuilder builder = new GCPFailureDomainBuilder(item);
    if (index < 0 || index >= gcp.size()) { _visitables.get("gcp").add(builder); gcp.add(builder); } else { _visitables.get("gcp").set(index, builder); gcp.set(index, builder);}
    return (A)this;
  }
  
  public A addToGcp(io.fabric8.openshift.api.model.machine.v1.GCPFailureDomain... items) {
    if (this.gcp == null) {this.gcp = new ArrayList<GCPFailureDomainBuilder>();}
    for (GCPFailureDomain item : items) {GCPFailureDomainBuilder builder = new GCPFailureDomainBuilder(item);_visitables.get("gcp").add(builder);this.gcp.add(builder);} return (A)this;
  }
  
  public A addAllToGcp(Collection<GCPFailureDomain> items) {
    if (this.gcp == null) {this.gcp = new ArrayList<GCPFailureDomainBuilder>();}
    for (GCPFailureDomain item : items) {GCPFailureDomainBuilder builder = new GCPFailureDomainBuilder(item);_visitables.get("gcp").add(builder);this.gcp.add(builder);} return (A)this;
  }
  
  public A removeFromGcp(io.fabric8.openshift.api.model.machine.v1.GCPFailureDomain... items) {
    if (this.gcp == null) return (A)this;
    for (GCPFailureDomain item : items) {GCPFailureDomainBuilder builder = new GCPFailureDomainBuilder(item);_visitables.get("gcp").remove(builder); this.gcp.remove(builder);} return (A)this;
  }
  
  public A removeAllFromGcp(Collection<GCPFailureDomain> items) {
    if (this.gcp == null) return (A)this;
    for (GCPFailureDomain item : items) {GCPFailureDomainBuilder builder = new GCPFailureDomainBuilder(item);_visitables.get("gcp").remove(builder); this.gcp.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromGcp(Predicate<GCPFailureDomainBuilder> predicate) {
    if (gcp == null) return (A) this;
    final Iterator<GCPFailureDomainBuilder> each = gcp.iterator();
    final List visitables = _visitables.get("gcp");
    while (each.hasNext()) {
      GCPFailureDomainBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GCPFailureDomain> buildGcp() {
    return this.gcp != null ? build(gcp) : null;
  }
  
  public GCPFailureDomain buildGcp(int index) {
    return this.gcp.get(index).build();
  }
  
  public GCPFailureDomain buildFirstGcp() {
    return this.gcp.get(0).build();
  }
  
  public GCPFailureDomain buildLastGcp() {
    return this.gcp.get(gcp.size() - 1).build();
  }
  
  public GCPFailureDomain buildMatchingGcp(Predicate<GCPFailureDomainBuilder> predicate) {
      for (GCPFailureDomainBuilder item : gcp) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingGcp(Predicate<GCPFailureDomainBuilder> predicate) {
      for (GCPFailureDomainBuilder item : gcp) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGcp(List<GCPFailureDomain> gcp) {
    if (this.gcp != null) {
      this._visitables.get("gcp").clear();
    }
    if (gcp != null) {
        this.gcp = new ArrayList();
        for (GCPFailureDomain item : gcp) {
          this.addToGcp(item);
        }
    } else {
      this.gcp = null;
    }
    return (A) this;
  }
  
  public A withGcp(io.fabric8.openshift.api.model.machine.v1.GCPFailureDomain... gcp) {
    if (this.gcp != null) {this.gcp.clear(); _visitables.remove("gcp"); }
    if (gcp != null) {for (GCPFailureDomain item :gcp){ this.addToGcp(item);}} return (A) this;
  }
  
  public boolean hasGcp() {
    return this.gcp != null && !this.gcp.isEmpty();
  }
  
  public A addNewGcp(String zone) {
    return (A)addToGcp(new GCPFailureDomain(zone));
  }
  
  public GcpNested<A> addNewGcp() {
    return new GcpNested(-1, null);
  }
  
  public GcpNested<A> addNewGcpLike(GCPFailureDomain item) {
    return new GcpNested(-1, item);
  }
  
  public GcpNested<A> setNewGcpLike(int index,GCPFailureDomain item) {
    return new GcpNested(index, item);
  }
  
  public GcpNested<A> editGcp(int index) {
    if (gcp.size() <= index) throw new RuntimeException("Can't edit gcp. Index exceeds size.");
    return setNewGcpLike(index, buildGcp(index));
  }
  
  public GcpNested<A> editFirstGcp() {
    if (gcp.size() == 0) throw new RuntimeException("Can't edit first gcp. The list is empty.");
    return setNewGcpLike(0, buildGcp(0));
  }
  
  public GcpNested<A> editLastGcp() {
    int index = gcp.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last gcp. The list is empty.");
    return setNewGcpLike(index, buildGcp(index));
  }
  
  public GcpNested<A> editMatchingGcp(Predicate<GCPFailureDomainBuilder> predicate) {
    int index = -1;
    for (int i=0;i<gcp.size();i++) { 
    if (predicate.test(gcp.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching gcp. No match found.");
    return setNewGcpLike(index, buildGcp(index));
  }
  
  public A addToOpenstack(int index,OpenStackFailureDomain item) {
    if (this.openstack == null) {this.openstack = new ArrayList<OpenStackFailureDomainBuilder>();}
    OpenStackFailureDomainBuilder builder = new OpenStackFailureDomainBuilder(item);
    if (index < 0 || index >= openstack.size()) { _visitables.get("openstack").add(builder); openstack.add(builder); } else { _visitables.get("openstack").add(index, builder); openstack.add(index, builder);}
    return (A)this;
  }
  
  public A setToOpenstack(int index,OpenStackFailureDomain item) {
    if (this.openstack == null) {this.openstack = new ArrayList<OpenStackFailureDomainBuilder>();}
    OpenStackFailureDomainBuilder builder = new OpenStackFailureDomainBuilder(item);
    if (index < 0 || index >= openstack.size()) { _visitables.get("openstack").add(builder); openstack.add(builder); } else { _visitables.get("openstack").set(index, builder); openstack.set(index, builder);}
    return (A)this;
  }
  
  public A addToOpenstack(io.fabric8.openshift.api.model.machine.v1.OpenStackFailureDomain... items) {
    if (this.openstack == null) {this.openstack = new ArrayList<OpenStackFailureDomainBuilder>();}
    for (OpenStackFailureDomain item : items) {OpenStackFailureDomainBuilder builder = new OpenStackFailureDomainBuilder(item);_visitables.get("openstack").add(builder);this.openstack.add(builder);} return (A)this;
  }
  
  public A addAllToOpenstack(Collection<OpenStackFailureDomain> items) {
    if (this.openstack == null) {this.openstack = new ArrayList<OpenStackFailureDomainBuilder>();}
    for (OpenStackFailureDomain item : items) {OpenStackFailureDomainBuilder builder = new OpenStackFailureDomainBuilder(item);_visitables.get("openstack").add(builder);this.openstack.add(builder);} return (A)this;
  }
  
  public A removeFromOpenstack(io.fabric8.openshift.api.model.machine.v1.OpenStackFailureDomain... items) {
    if (this.openstack == null) return (A)this;
    for (OpenStackFailureDomain item : items) {OpenStackFailureDomainBuilder builder = new OpenStackFailureDomainBuilder(item);_visitables.get("openstack").remove(builder); this.openstack.remove(builder);} return (A)this;
  }
  
  public A removeAllFromOpenstack(Collection<OpenStackFailureDomain> items) {
    if (this.openstack == null) return (A)this;
    for (OpenStackFailureDomain item : items) {OpenStackFailureDomainBuilder builder = new OpenStackFailureDomainBuilder(item);_visitables.get("openstack").remove(builder); this.openstack.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromOpenstack(Predicate<OpenStackFailureDomainBuilder> predicate) {
    if (openstack == null) return (A) this;
    final Iterator<OpenStackFailureDomainBuilder> each = openstack.iterator();
    final List visitables = _visitables.get("openstack");
    while (each.hasNext()) {
      OpenStackFailureDomainBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<OpenStackFailureDomain> buildOpenstack() {
    return this.openstack != null ? build(openstack) : null;
  }
  
  public OpenStackFailureDomain buildOpenstack(int index) {
    return this.openstack.get(index).build();
  }
  
  public OpenStackFailureDomain buildFirstOpenstack() {
    return this.openstack.get(0).build();
  }
  
  public OpenStackFailureDomain buildLastOpenstack() {
    return this.openstack.get(openstack.size() - 1).build();
  }
  
  public OpenStackFailureDomain buildMatchingOpenstack(Predicate<OpenStackFailureDomainBuilder> predicate) {
      for (OpenStackFailureDomainBuilder item : openstack) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingOpenstack(Predicate<OpenStackFailureDomainBuilder> predicate) {
      for (OpenStackFailureDomainBuilder item : openstack) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withOpenstack(List<OpenStackFailureDomain> openstack) {
    if (this.openstack != null) {
      this._visitables.get("openstack").clear();
    }
    if (openstack != null) {
        this.openstack = new ArrayList();
        for (OpenStackFailureDomain item : openstack) {
          this.addToOpenstack(item);
        }
    } else {
      this.openstack = null;
    }
    return (A) this;
  }
  
  public A withOpenstack(io.fabric8.openshift.api.model.machine.v1.OpenStackFailureDomain... openstack) {
    if (this.openstack != null) {this.openstack.clear(); _visitables.remove("openstack"); }
    if (openstack != null) {for (OpenStackFailureDomain item :openstack){ this.addToOpenstack(item);}} return (A) this;
  }
  
  public boolean hasOpenstack() {
    return this.openstack != null && !this.openstack.isEmpty();
  }
  
  public OpenstackNested<A> addNewOpenstack() {
    return new OpenstackNested(-1, null);
  }
  
  public OpenstackNested<A> addNewOpenstackLike(OpenStackFailureDomain item) {
    return new OpenstackNested(-1, item);
  }
  
  public OpenstackNested<A> setNewOpenstackLike(int index,OpenStackFailureDomain item) {
    return new OpenstackNested(index, item);
  }
  
  public OpenstackNested<A> editOpenstack(int index) {
    if (openstack.size() <= index) throw new RuntimeException("Can't edit openstack. Index exceeds size.");
    return setNewOpenstackLike(index, buildOpenstack(index));
  }
  
  public OpenstackNested<A> editFirstOpenstack() {
    if (openstack.size() == 0) throw new RuntimeException("Can't edit first openstack. The list is empty.");
    return setNewOpenstackLike(0, buildOpenstack(0));
  }
  
  public OpenstackNested<A> editLastOpenstack() {
    int index = openstack.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last openstack. The list is empty.");
    return setNewOpenstackLike(index, buildOpenstack(index));
  }
  
  public OpenstackNested<A> editMatchingOpenstack(Predicate<OpenStackFailureDomainBuilder> predicate) {
    int index = -1;
    for (int i=0;i<openstack.size();i++) { 
    if (predicate.test(openstack.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching openstack. No match found.");
    return setNewOpenstackLike(index, buildOpenstack(index));
  }
  
  public String getPlatform() {
    return this.platform;
  }
  
  public A withPlatform(String platform) {
    this.platform = platform;
    return (A) this;
  }
  
  public boolean hasPlatform() {
    return this.platform != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    FailureDomainsFluent that = (FailureDomainsFluent) o;
    if (!java.util.Objects.equals(aws, that.aws)) return false;
    if (!java.util.Objects.equals(azure, that.azure)) return false;
    if (!java.util.Objects.equals(gcp, that.gcp)) return false;
    if (!java.util.Objects.equals(openstack, that.openstack)) return false;
    if (!java.util.Objects.equals(platform, that.platform)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(aws,  azure,  gcp,  openstack,  platform,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null && !aws.isEmpty()) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null && !azure.isEmpty()) { sb.append("azure:"); sb.append(azure + ","); }
    if (gcp != null && !gcp.isEmpty()) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (openstack != null && !openstack.isEmpty()) { sb.append("openstack:"); sb.append(openstack + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AwsNested<N> extends AWSFailureDomainFluent<AwsNested<N>> implements Nested<N>{
    AwsNested(int index,AWSFailureDomain item) {
      this.index = index;
      this.builder = new AWSFailureDomainBuilder(this, item);
    }
    AWSFailureDomainBuilder builder;
    int index;
    
    public N and() {
      return (N) FailureDomainsFluent.this.setToAws(index,builder.build());
    }
    
    public N endAw() {
      return and();
    }
    
  
  }
  public class AzureNested<N> extends AzureFailureDomainFluent<AzureNested<N>> implements Nested<N>{
    AzureNested(int index,AzureFailureDomain item) {
      this.index = index;
      this.builder = new AzureFailureDomainBuilder(this, item);
    }
    AzureFailureDomainBuilder builder;
    int index;
    
    public N and() {
      return (N) FailureDomainsFluent.this.setToAzure(index,builder.build());
    }
    
    public N endAzure() {
      return and();
    }
    
  
  }
  public class GcpNested<N> extends GCPFailureDomainFluent<GcpNested<N>> implements Nested<N>{
    GcpNested(int index,GCPFailureDomain item) {
      this.index = index;
      this.builder = new GCPFailureDomainBuilder(this, item);
    }
    GCPFailureDomainBuilder builder;
    int index;
    
    public N and() {
      return (N) FailureDomainsFluent.this.setToGcp(index,builder.build());
    }
    
    public N endGcp() {
      return and();
    }
    
  
  }
  public class OpenstackNested<N> extends OpenStackFailureDomainFluent<OpenstackNested<N>> implements Nested<N>{
    OpenstackNested(int index,OpenStackFailureDomain item) {
      this.index = index;
      this.builder = new OpenStackFailureDomainBuilder(this, item);
    }
    OpenStackFailureDomainBuilder builder;
    int index;
    
    public N and() {
      return (N) FailureDomainsFluent.this.setToOpenstack(index,builder.build());
    }
    
    public N endOpenstack() {
      return and();
    }
    
  
  }

}