/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1alpha1.Filter;
import io.fabric8.openshift.api.model.machine.v1alpha1.FilterBuilder;
import io.fabric8.openshift.api.model.machine.v1alpha1.FilterFluent;
import io.fabric8.openshift.api.model.machine.v1alpha1.NetworkParam;
import io.fabric8.openshift.api.model.machine.v1alpha1.SubnetParam;
import io.fabric8.openshift.api.model.machine.v1alpha1.SubnetParamBuilder;
import io.fabric8.openshift.api.model.machine.v1alpha1.SubnetParamFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NetworkParamFluent<A extends NetworkParamFluent<A>>
extends BaseFluent<A> {
    private FilterBuilder filter;
    private String fixedIp;
    private Boolean noAllowedAddressPairs;
    private Boolean portSecurity;
    private List<String> portTags = new ArrayList<String>();
    private Map<String, String> profile;
    private ArrayList<SubnetParamBuilder> subnets = new ArrayList();
    private String uuid;
    private String vnicType;
    private Map<String, Object> additionalProperties;

    public NetworkParamFluent() {
    }

    public NetworkParamFluent(NetworkParam instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkParam instance) {
        NetworkParam networkParam = instance = instance != null ? instance : new NetworkParam();
        if (instance != null) {
            this.withFilter(instance.getFilter());
            this.withFixedIp(instance.getFixedIp());
            this.withNoAllowedAddressPairs(instance.getNoAllowedAddressPairs());
            this.withPortSecurity(instance.getPortSecurity());
            this.withPortTags(instance.getPortTags());
            this.withProfile(instance.getProfile());
            this.withSubnets(instance.getSubnets());
            this.withUuid(instance.getUuid());
            this.withVnicType(instance.getVnicType());
            this.withFilter(instance.getFilter());
            this.withFixedIp(instance.getFixedIp());
            this.withNoAllowedAddressPairs(instance.getNoAllowedAddressPairs());
            this.withPortSecurity(instance.getPortSecurity());
            this.withPortTags(instance.getPortTags());
            this.withProfile(instance.getProfile());
            this.withSubnets(instance.getSubnets());
            this.withUuid(instance.getUuid());
            this.withVnicType(instance.getVnicType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Filter buildFilter() {
        return this.filter != null ? this.filter.build() : null;
    }

    public A withFilter(Filter filter) {
        this._visitables.remove((Object)this.filter);
        if (filter != null) {
            this.filter = new FilterBuilder(filter);
            this._visitables.get((Object)"filter").add(this.filter);
        } else {
            this.filter = null;
            this._visitables.get((Object)"filter").remove((Object)this.filter);
        }
        return (A)((Object)this);
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public FilterNested<A> withNewFilter() {
        return new FilterNested(null);
    }

    public FilterNested<A> withNewFilterLike(Filter item) {
        return new FilterNested(item);
    }

    public FilterNested<A> editFilter() {
        return this.withNewFilterLike(Optional.ofNullable(this.buildFilter()).orElse(null));
    }

    public FilterNested<A> editOrNewFilter() {
        return this.withNewFilterLike(Optional.ofNullable(this.buildFilter()).orElse(new FilterBuilder().build()));
    }

    public FilterNested<A> editOrNewFilterLike(Filter item) {
        return this.withNewFilterLike(Optional.ofNullable(this.buildFilter()).orElse(item));
    }

    public String getFixedIp() {
        return this.fixedIp;
    }

    public A withFixedIp(String fixedIp) {
        this.fixedIp = fixedIp;
        return (A)((Object)this);
    }

    public boolean hasFixedIp() {
        return this.fixedIp != null;
    }

    public Boolean getNoAllowedAddressPairs() {
        return this.noAllowedAddressPairs;
    }

    public A withNoAllowedAddressPairs(Boolean noAllowedAddressPairs) {
        this.noAllowedAddressPairs = noAllowedAddressPairs;
        return (A)((Object)this);
    }

    public boolean hasNoAllowedAddressPairs() {
        return this.noAllowedAddressPairs != null;
    }

    public Boolean getPortSecurity() {
        return this.portSecurity;
    }

    public A withPortSecurity(Boolean portSecurity) {
        this.portSecurity = portSecurity;
        return (A)((Object)this);
    }

    public boolean hasPortSecurity() {
        return this.portSecurity != null;
    }

    public A addToPortTags(int index, String item) {
        if (this.portTags == null) {
            this.portTags = new ArrayList<String>();
        }
        this.portTags.add(index, item);
        return (A)((Object)this);
    }

    public A setToPortTags(int index, String item) {
        if (this.portTags == null) {
            this.portTags = new ArrayList<String>();
        }
        this.portTags.set(index, item);
        return (A)((Object)this);
    }

    public A addToPortTags(String ... items) {
        if (this.portTags == null) {
            this.portTags = new ArrayList<String>();
        }
        for (String item : items) {
            this.portTags.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPortTags(Collection<String> items) {
        if (this.portTags == null) {
            this.portTags = new ArrayList<String>();
        }
        for (String item : items) {
            this.portTags.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPortTags(String ... items) {
        if (this.portTags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.portTags.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPortTags(Collection<String> items) {
        if (this.portTags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.portTags.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPortTags() {
        return this.portTags;
    }

    public String getPortTag(int index) {
        return this.portTags.get(index);
    }

    public String getFirstPortTag() {
        return this.portTags.get(0);
    }

    public String getLastPortTag() {
        return this.portTags.get(this.portTags.size() - 1);
    }

    public String getMatchingPortTag(Predicate<String> predicate) {
        for (String item : this.portTags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPortTag(Predicate<String> predicate) {
        for (String item : this.portTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPortTags(List<String> portTags) {
        if (portTags != null) {
            this.portTags = new ArrayList<String>();
            for (String item : portTags) {
                this.addToPortTags(item);
            }
        } else {
            this.portTags = null;
        }
        return (A)((Object)this);
    }

    public A withPortTags(String ... portTags) {
        if (this.portTags != null) {
            this.portTags.clear();
            this._visitables.remove((Object)"portTags");
        }
        if (portTags != null) {
            for (String item : portTags) {
                this.addToPortTags(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPortTags() {
        return this.portTags != null && !this.portTags.isEmpty();
    }

    public A addToProfile(String key, String value) {
        if (this.profile == null && key != null && value != null) {
            this.profile = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.profile.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToProfile(Map<String, String> map) {
        if (this.profile == null && map != null) {
            this.profile = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.profile.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromProfile(String key) {
        if (this.profile == null) {
            return (A)((Object)this);
        }
        if (key != null && this.profile != null) {
            this.profile.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromProfile(Map<String, String> map) {
        if (this.profile == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.profile == null) continue;
                this.profile.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getProfile() {
        return this.profile;
    }

    public <K, V> A withProfile(Map<String, String> profile) {
        this.profile = profile == null ? null : new LinkedHashMap<String, String>(profile);
        return (A)((Object)this);
    }

    public boolean hasProfile() {
        return this.profile != null;
    }

    public A addToSubnets(int index, SubnetParam item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        SubnetParamBuilder builder = new SubnetParamBuilder(item);
        if (index < 0 || index >= this.subnets.size()) {
            this._visitables.get((Object)"subnets").add(builder);
            this.subnets.add(builder);
        } else {
            this._visitables.get((Object)"subnets").add(index, builder);
            this.subnets.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSubnets(int index, SubnetParam item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        SubnetParamBuilder builder = new SubnetParamBuilder(item);
        if (index < 0 || index >= this.subnets.size()) {
            this._visitables.get((Object)"subnets").add(builder);
            this.subnets.add(builder);
        } else {
            this._visitables.get((Object)"subnets").set(index, builder);
            this.subnets.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSubnets(SubnetParam ... items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        for (SubnetParam item : items) {
            SubnetParamBuilder builder = new SubnetParamBuilder(item);
            this._visitables.get((Object)"subnets").add(builder);
            this.subnets.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSubnets(Collection<SubnetParam> items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        for (SubnetParam item : items) {
            SubnetParamBuilder builder = new SubnetParamBuilder(item);
            this._visitables.get((Object)"subnets").add(builder);
            this.subnets.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSubnets(SubnetParam ... items) {
        if (this.subnets == null) {
            return (A)((Object)this);
        }
        for (SubnetParam item : items) {
            SubnetParamBuilder builder = new SubnetParamBuilder(item);
            this._visitables.get((Object)"subnets").remove((Object)builder);
            this.subnets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSubnets(Collection<SubnetParam> items) {
        if (this.subnets == null) {
            return (A)((Object)this);
        }
        for (SubnetParam item : items) {
            SubnetParamBuilder builder = new SubnetParamBuilder(item);
            this._visitables.get((Object)"subnets").remove((Object)builder);
            this.subnets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSubnets(Predicate<SubnetParamBuilder> predicate) {
        if (this.subnets == null) {
            return (A)((Object)this);
        }
        Iterator<SubnetParamBuilder> each = this.subnets.iterator();
        List visitables = this._visitables.get((Object)"subnets");
        while (each.hasNext()) {
            SubnetParamBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<SubnetParam> buildSubnets() {
        return this.subnets != null ? NetworkParamFluent.build(this.subnets) : null;
    }

    public SubnetParam buildSubnet(int index) {
        return this.subnets.get(index).build();
    }

    public SubnetParam buildFirstSubnet() {
        return this.subnets.get(0).build();
    }

    public SubnetParam buildLastSubnet() {
        return this.subnets.get(this.subnets.size() - 1).build();
    }

    public SubnetParam buildMatchingSubnet(Predicate<SubnetParamBuilder> predicate) {
        for (SubnetParamBuilder item : this.subnets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubnet(Predicate<SubnetParamBuilder> predicate) {
        for (SubnetParamBuilder item : this.subnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubnets(List<SubnetParam> subnets) {
        if (this.subnets != null) {
            this._visitables.get((Object)"subnets").clear();
        }
        if (subnets != null) {
            this.subnets = new ArrayList();
            for (SubnetParam item : subnets) {
                this.addToSubnets(item);
            }
        } else {
            this.subnets = null;
        }
        return (A)((Object)this);
    }

    public A withSubnets(SubnetParam ... subnets) {
        if (this.subnets != null) {
            this.subnets.clear();
            this._visitables.remove((Object)"subnets");
        }
        if (subnets != null) {
            for (SubnetParam item : subnets) {
                this.addToSubnets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSubnets() {
        return this.subnets != null && !this.subnets.isEmpty();
    }

    public SubnetsNested<A> addNewSubnet() {
        return new SubnetsNested(-1, null);
    }

    public SubnetsNested<A> addNewSubnetLike(SubnetParam item) {
        return new SubnetsNested(-1, item);
    }

    public SubnetsNested<A> setNewSubnetLike(int index, SubnetParam item) {
        return new SubnetsNested(index, item);
    }

    public SubnetsNested<A> editSubnet(int index) {
        if (this.subnets.size() <= index) {
            throw new RuntimeException("Can't edit subnets. Index exceeds size.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    public SubnetsNested<A> editFirstSubnet() {
        if (this.subnets.size() == 0) {
            throw new RuntimeException("Can't edit first subnets. The list is empty.");
        }
        return this.setNewSubnetLike(0, this.buildSubnet(0));
    }

    public SubnetsNested<A> editLastSubnet() {
        int index = this.subnets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subnets. The list is empty.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    public SubnetsNested<A> editMatchingSubnet(Predicate<SubnetParamBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subnets.size(); ++i) {
            if (!predicate.test(this.subnets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subnets. No match found.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    public String getUuid() {
        return this.uuid;
    }

    public A withUuid(String uuid) {
        this.uuid = uuid;
        return (A)((Object)this);
    }

    public boolean hasUuid() {
        return this.uuid != null;
    }

    public String getVnicType() {
        return this.vnicType;
    }

    public A withVnicType(String vnicType) {
        this.vnicType = vnicType;
        return (A)((Object)this);
    }

    public boolean hasVnicType() {
        return this.vnicType != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkParamFluent that = (NetworkParamFluent)((Object)o);
        if (!Objects.equals((Object)this.filter, (Object)that.filter)) {
            return false;
        }
        if (!Objects.equals(this.fixedIp, that.fixedIp)) {
            return false;
        }
        if (!Objects.equals(this.noAllowedAddressPairs, that.noAllowedAddressPairs)) {
            return false;
        }
        if (!Objects.equals(this.portSecurity, that.portSecurity)) {
            return false;
        }
        if (!Objects.equals(this.portTags, that.portTags)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        if (!Objects.equals(this.subnets, that.subnets)) {
            return false;
        }
        if (!Objects.equals(this.uuid, that.uuid)) {
            return false;
        }
        if (!Objects.equals(this.vnicType, that.vnicType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filter, this.fixedIp, this.noAllowedAddressPairs, this.portSecurity, this.portTags, this.profile, this.subnets, this.uuid, this.vnicType, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filter != null) {
            sb.append("filter:");
            sb.append((Object)((Object)this.filter) + ",");
        }
        if (this.fixedIp != null) {
            sb.append("fixedIp:");
            sb.append(this.fixedIp + ",");
        }
        if (this.noAllowedAddressPairs != null) {
            sb.append("noAllowedAddressPairs:");
            sb.append(this.noAllowedAddressPairs + ",");
        }
        if (this.portSecurity != null) {
            sb.append("portSecurity:");
            sb.append(this.portSecurity + ",");
        }
        if (this.portTags != null && !this.portTags.isEmpty()) {
            sb.append("portTags:");
            sb.append(this.portTags + ",");
        }
        if (this.profile != null && !this.profile.isEmpty()) {
            sb.append("profile:");
            sb.append(this.profile + ",");
        }
        if (this.subnets != null && !this.subnets.isEmpty()) {
            sb.append("subnets:");
            sb.append(this.subnets + ",");
        }
        if (this.uuid != null) {
            sb.append("uuid:");
            sb.append(this.uuid + ",");
        }
        if (this.vnicType != null) {
            sb.append("vnicType:");
            sb.append(this.vnicType + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withNoAllowedAddressPairs() {
        return this.withNoAllowedAddressPairs(true);
    }

    public A withPortSecurity() {
        return this.withPortSecurity(true);
    }

    public class SubnetsNested<N>
    extends SubnetParamFluent<SubnetsNested<N>>
    implements Nested<N> {
        SubnetParamBuilder builder;
        int index;

        SubnetsNested(int index, SubnetParam item) {
            this.index = index;
            this.builder = new SubnetParamBuilder(this, item);
        }

        public N and() {
            return (N)NetworkParamFluent.this.setToSubnets(this.index, this.builder.build());
        }

        public N endSubnet() {
            return this.and();
        }
    }

    public class FilterNested<N>
    extends FilterFluent<FilterNested<N>>
    implements Nested<N> {
        FilterBuilder builder;

        FilterNested(Filter item) {
            this.builder = new FilterBuilder(this, item);
        }

        public N and() {
            return (N)NetworkParamFluent.this.withFilter(this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }
}

