package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureFailureDomainBuilder extends AzureFailureDomainFluent<AzureFailureDomainBuilder> implements VisitableBuilder<AzureFailureDomain,AzureFailureDomainBuilder>{
  public AzureFailureDomainBuilder() {
    this(new AzureFailureDomain());
  }
  
  public AzureFailureDomainBuilder(AzureFailureDomainFluent<?> fluent) {
    this(fluent, new AzureFailureDomain());
  }
  
  public AzureFailureDomainBuilder(AzureFailureDomainFluent<?> fluent,AzureFailureDomain instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureFailureDomainBuilder(AzureFailureDomain instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureFailureDomainFluent<?> fluent;
  
  public AzureFailureDomain build() {
    AzureFailureDomain buildable = new AzureFailureDomain(fluent.getZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}