package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineSetSpecBuilder extends MachineSetSpecFluent<MachineSetSpecBuilder> implements VisitableBuilder<MachineSetSpec,MachineSetSpecBuilder>{
  public MachineSetSpecBuilder() {
    this(new MachineSetSpec());
  }
  
  public MachineSetSpecBuilder(MachineSetSpecFluent<?> fluent) {
    this(fluent, new MachineSetSpec());
  }
  
  public MachineSetSpecBuilder(MachineSetSpecFluent<?> fluent,MachineSetSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineSetSpecBuilder(MachineSetSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineSetSpecFluent<?> fluent;
  
  public MachineSetSpec build() {
    MachineSetSpec buildable = new MachineSetSpec(fluent.getAuthoritativeAPI(),fluent.getDeletePolicy(),fluent.getMinReadySeconds(),fluent.getReplicas(),fluent.buildSelector(),fluent.buildTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}