package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PowerVSResourceBuilder extends PowerVSResourceFluent<PowerVSResourceBuilder> implements VisitableBuilder<PowerVSResource,PowerVSResourceBuilder>{
  public PowerVSResourceBuilder() {
    this(new PowerVSResource());
  }
  
  public PowerVSResourceBuilder(PowerVSResourceFluent<?> fluent) {
    this(fluent, new PowerVSResource());
  }
  
  public PowerVSResourceBuilder(PowerVSResourceFluent<?> fluent,PowerVSResource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PowerVSResourceBuilder(PowerVSResource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PowerVSResourceFluent<?> fluent;
  
  public PowerVSResource build() {
    PowerVSResource buildable = new PowerVSResource(fluent.getId(),fluent.getName(),fluent.getRegex(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}