package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BlockDeviceMappingSpecBuilder extends BlockDeviceMappingSpecFluent<BlockDeviceMappingSpecBuilder> implements VisitableBuilder<BlockDeviceMappingSpec,BlockDeviceMappingSpecBuilder>{
  public BlockDeviceMappingSpecBuilder() {
    this(new BlockDeviceMappingSpec());
  }
  
  public BlockDeviceMappingSpecBuilder(BlockDeviceMappingSpecFluent<?> fluent) {
    this(fluent, new BlockDeviceMappingSpec());
  }
  
  public BlockDeviceMappingSpecBuilder(BlockDeviceMappingSpecFluent<?> fluent,BlockDeviceMappingSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BlockDeviceMappingSpecBuilder(BlockDeviceMappingSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BlockDeviceMappingSpecFluent<?> fluent;
  
  public BlockDeviceMappingSpec build() {
    BlockDeviceMappingSpec buildable = new BlockDeviceMappingSpec(fluent.getDeviceName(),fluent.buildEbs(),fluent.getNoDevice(),fluent.getVirtualName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}