package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkDeviceSpecBuilder extends NetworkDeviceSpecFluent<NetworkDeviceSpecBuilder> implements VisitableBuilder<NetworkDeviceSpec,NetworkDeviceSpecBuilder>{
  public NetworkDeviceSpecBuilder() {
    this(new NetworkDeviceSpec());
  }
  
  public NetworkDeviceSpecBuilder(NetworkDeviceSpecFluent<?> fluent) {
    this(fluent, new NetworkDeviceSpec());
  }
  
  public NetworkDeviceSpecBuilder(NetworkDeviceSpecFluent<?> fluent,NetworkDeviceSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkDeviceSpecBuilder(NetworkDeviceSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkDeviceSpecFluent<?> fluent;
  
  public NetworkDeviceSpec build() {
    NetworkDeviceSpec buildable = new NetworkDeviceSpec(fluent.buildAddressesFromPools(),fluent.getGateway(),fluent.getIpAddrs(),fluent.getNameservers(),fluent.getNetworkName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}