package io.fabric8.openshift.api.model.machine.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OSDiskFluent<A extends OSDiskFluent<A>> extends BaseFluent<A>{
  public OSDiskFluent() {
  }
  
  public OSDiskFluent(OSDisk instance) {
    this.copyInstance(instance);
  }
  private String cachingType;
  private DiskSettingsBuilder diskSettings;
  private Integer diskSizeGB;
  private OSDiskManagedDiskParametersBuilder managedDisk;
  private String osType;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OSDisk instance) {
    instance = (instance != null ? instance : new OSDisk());
    if (instance != null) {
          this.withCachingType(instance.getCachingType());
          this.withDiskSettings(instance.getDiskSettings());
          this.withDiskSizeGB(instance.getDiskSizeGB());
          this.withManagedDisk(instance.getManagedDisk());
          this.withOsType(instance.getOsType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCachingType() {
    return this.cachingType;
  }
  
  public A withCachingType(String cachingType) {
    this.cachingType = cachingType;
    return (A) this;
  }
  
  public boolean hasCachingType() {
    return this.cachingType != null;
  }
  
  public DiskSettings buildDiskSettings() {
    return this.diskSettings != null ? this.diskSettings.build() : null;
  }
  
  public A withDiskSettings(DiskSettings diskSettings) {
    this._visitables.remove("diskSettings");
    if (diskSettings != null) {
        this.diskSettings = new DiskSettingsBuilder(diskSettings);
        this._visitables.get("diskSettings").add(this.diskSettings);
    } else {
        this.diskSettings = null;
        this._visitables.get("diskSettings").remove(this.diskSettings);
    }
    return (A) this;
  }
  
  public boolean hasDiskSettings() {
    return this.diskSettings != null;
  }
  
  public A withNewDiskSettings(String ephemeralStorageLocation) {
    return (A)withDiskSettings(new DiskSettings(ephemeralStorageLocation));
  }
  
  public DiskSettingsNested<A> withNewDiskSettings() {
    return new DiskSettingsNested(null);
  }
  
  public DiskSettingsNested<A> withNewDiskSettingsLike(DiskSettings item) {
    return new DiskSettingsNested(item);
  }
  
  public DiskSettingsNested<A> editDiskSettings() {
    return withNewDiskSettingsLike(java.util.Optional.ofNullable(buildDiskSettings()).orElse(null));
  }
  
  public DiskSettingsNested<A> editOrNewDiskSettings() {
    return withNewDiskSettingsLike(java.util.Optional.ofNullable(buildDiskSettings()).orElse(new DiskSettingsBuilder().build()));
  }
  
  public DiskSettingsNested<A> editOrNewDiskSettingsLike(DiskSettings item) {
    return withNewDiskSettingsLike(java.util.Optional.ofNullable(buildDiskSettings()).orElse(item));
  }
  
  public Integer getDiskSizeGB() {
    return this.diskSizeGB;
  }
  
  public A withDiskSizeGB(Integer diskSizeGB) {
    this.diskSizeGB = diskSizeGB;
    return (A) this;
  }
  
  public boolean hasDiskSizeGB() {
    return this.diskSizeGB != null;
  }
  
  public OSDiskManagedDiskParameters buildManagedDisk() {
    return this.managedDisk != null ? this.managedDisk.build() : null;
  }
  
  public A withManagedDisk(OSDiskManagedDiskParameters managedDisk) {
    this._visitables.remove("managedDisk");
    if (managedDisk != null) {
        this.managedDisk = new OSDiskManagedDiskParametersBuilder(managedDisk);
        this._visitables.get("managedDisk").add(this.managedDisk);
    } else {
        this.managedDisk = null;
        this._visitables.get("managedDisk").remove(this.managedDisk);
    }
    return (A) this;
  }
  
  public boolean hasManagedDisk() {
    return this.managedDisk != null;
  }
  
  public ManagedDiskNested<A> withNewManagedDisk() {
    return new ManagedDiskNested(null);
  }
  
  public ManagedDiskNested<A> withNewManagedDiskLike(OSDiskManagedDiskParameters item) {
    return new ManagedDiskNested(item);
  }
  
  public ManagedDiskNested<A> editManagedDisk() {
    return withNewManagedDiskLike(java.util.Optional.ofNullable(buildManagedDisk()).orElse(null));
  }
  
  public ManagedDiskNested<A> editOrNewManagedDisk() {
    return withNewManagedDiskLike(java.util.Optional.ofNullable(buildManagedDisk()).orElse(new OSDiskManagedDiskParametersBuilder().build()));
  }
  
  public ManagedDiskNested<A> editOrNewManagedDiskLike(OSDiskManagedDiskParameters item) {
    return withNewManagedDiskLike(java.util.Optional.ofNullable(buildManagedDisk()).orElse(item));
  }
  
  public String getOsType() {
    return this.osType;
  }
  
  public A withOsType(String osType) {
    this.osType = osType;
    return (A) this;
  }
  
  public boolean hasOsType() {
    return this.osType != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OSDiskFluent that = (OSDiskFluent) o;
    if (!java.util.Objects.equals(cachingType, that.cachingType)) return false;
    if (!java.util.Objects.equals(diskSettings, that.diskSettings)) return false;
    if (!java.util.Objects.equals(diskSizeGB, that.diskSizeGB)) return false;
    if (!java.util.Objects.equals(managedDisk, that.managedDisk)) return false;
    if (!java.util.Objects.equals(osType, that.osType)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cachingType,  diskSettings,  diskSizeGB,  managedDisk,  osType,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cachingType != null) { sb.append("cachingType:"); sb.append(cachingType + ","); }
    if (diskSettings != null) { sb.append("diskSettings:"); sb.append(diskSettings + ","); }
    if (diskSizeGB != null) { sb.append("diskSizeGB:"); sb.append(diskSizeGB + ","); }
    if (managedDisk != null) { sb.append("managedDisk:"); sb.append(managedDisk + ","); }
    if (osType != null) { sb.append("osType:"); sb.append(osType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DiskSettingsNested<N> extends DiskSettingsFluent<DiskSettingsNested<N>> implements Nested<N>{
    DiskSettingsNested(DiskSettings item) {
      this.builder = new DiskSettingsBuilder(this, item);
    }
    DiskSettingsBuilder builder;
    
    public N and() {
      return (N) OSDiskFluent.this.withDiskSettings(builder.build());
    }
    
    public N endDiskSettings() {
      return and();
    }
    
  
  }
  public class ManagedDiskNested<N> extends OSDiskManagedDiskParametersFluent<ManagedDiskNested<N>> implements Nested<N>{
    ManagedDiskNested(OSDiskManagedDiskParameters item) {
      this.builder = new OSDiskManagedDiskParametersBuilder(this, item);
    }
    OSDiskManagedDiskParametersBuilder builder;
    
    public N and() {
      return (N) OSDiskFluent.this.withManagedDisk(builder.build());
    }
    
    public N endManagedDisk() {
      return and();
    }
    
  
  }

}