package io.fabric8.openshift.api.model.machine.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SecurityProfileFluent<A extends SecurityProfileFluent<A>> extends BaseFluent<A>{
  public SecurityProfileFluent() {
  }
  
  public SecurityProfileFluent(SecurityProfile instance) {
    this.copyInstance(instance);
  }
  private Boolean encryptionAtHost;
  private SecuritySettingsBuilder settings;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SecurityProfile instance) {
    instance = (instance != null ? instance : new SecurityProfile());
    if (instance != null) {
          this.withEncryptionAtHost(instance.getEncryptionAtHost());
          this.withSettings(instance.getSettings());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getEncryptionAtHost() {
    return this.encryptionAtHost;
  }
  
  public A withEncryptionAtHost(Boolean encryptionAtHost) {
    this.encryptionAtHost = encryptionAtHost;
    return (A) this;
  }
  
  public boolean hasEncryptionAtHost() {
    return this.encryptionAtHost != null;
  }
  
  public SecuritySettings buildSettings() {
    return this.settings != null ? this.settings.build() : null;
  }
  
  public A withSettings(SecuritySettings settings) {
    this._visitables.remove("settings");
    if (settings != null) {
        this.settings = new SecuritySettingsBuilder(settings);
        this._visitables.get("settings").add(this.settings);
    } else {
        this.settings = null;
        this._visitables.get("settings").remove(this.settings);
    }
    return (A) this;
  }
  
  public boolean hasSettings() {
    return this.settings != null;
  }
  
  public SettingsNested<A> withNewSettings() {
    return new SettingsNested(null);
  }
  
  public SettingsNested<A> withNewSettingsLike(SecuritySettings item) {
    return new SettingsNested(item);
  }
  
  public SettingsNested<A> editSettings() {
    return withNewSettingsLike(java.util.Optional.ofNullable(buildSettings()).orElse(null));
  }
  
  public SettingsNested<A> editOrNewSettings() {
    return withNewSettingsLike(java.util.Optional.ofNullable(buildSettings()).orElse(new SecuritySettingsBuilder().build()));
  }
  
  public SettingsNested<A> editOrNewSettingsLike(SecuritySettings item) {
    return withNewSettingsLike(java.util.Optional.ofNullable(buildSettings()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecurityProfileFluent that = (SecurityProfileFluent) o;
    if (!java.util.Objects.equals(encryptionAtHost, that.encryptionAtHost)) return false;
    if (!java.util.Objects.equals(settings, that.settings)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(encryptionAtHost,  settings,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (encryptionAtHost != null) { sb.append("encryptionAtHost:"); sb.append(encryptionAtHost + ","); }
    if (settings != null) { sb.append("settings:"); sb.append(settings + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withEncryptionAtHost() {
    return withEncryptionAtHost(true);
  }
  public class SettingsNested<N> extends SecuritySettingsFluent<SettingsNested<N>> implements Nested<N>{
    SettingsNested(SecuritySettings item) {
      this.builder = new SecuritySettingsBuilder(this, item);
    }
    SecuritySettingsBuilder builder;
    
    public N and() {
      return (N) SecurityProfileFluent.this.withSettings(builder.build());
    }
    
    public N endSettings() {
      return and();
    }
    
  
  }

}