package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class KubeletConfigSpecBuilder extends io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpecFluentImpl<io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpec,io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpecBuilder>{
  public KubeletConfigSpecBuilder() {
    this(false);
  }
  public KubeletConfigSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new KubeletConfigSpec(), validationEnabled);
  }
  public KubeletConfigSpecBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeletConfigSpecBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new KubeletConfigSpec(), validationEnabled);
  }
  public KubeletConfigSpecBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpecFluent<?> fluent,io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpec instance) {
    this(fluent, instance, false);
  }
  public KubeletConfigSpecBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpecFluent<?> fluent,io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAutoSizingReserved(instance.getAutoSizingReserved()); 
    fluent.withKubeletConfig(instance.getKubeletConfig()); 
    fluent.withLogLevel(instance.getLogLevel()); 
    fluent.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector()); 
    fluent.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KubeletConfigSpecBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpec instance) {
    this(instance,false);
  }
  public KubeletConfigSpecBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAutoSizingReserved(instance.getAutoSizingReserved()); 
    this.withKubeletConfig(instance.getKubeletConfig()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector()); 
    this.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpec build() {
    KubeletConfigSpec buildable = new KubeletConfigSpec(fluent.getAutoSizingReserved(),fluent.getKubeletConfig(),fluent.getLogLevel(),fluent.getMachineConfigPoolSelector(),fluent.getTlsSecurityProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubeletConfigSpecBuilder that = (KubeletConfigSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}