package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ControllerConfigBuilder extends io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigFluentImpl<io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfig,io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigBuilder> {

    io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ControllerConfigBuilder() {
        this(true);
    }

    public ControllerConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new ControllerConfig(), validationEnabled);
    }

    public ControllerConfigBuilder(io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public ControllerConfigBuilder(io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ControllerConfig(), validationEnabled);
    }

    public ControllerConfigBuilder(io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigFluent<?> fluent,io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfig instance) {
        this(fluent, instance, true);
    }

    public ControllerConfigBuilder(io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigFluent<?> fluent,io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ControllerConfigBuilder(io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfig instance) {
        this(instance,true);
    }

    public ControllerConfigBuilder(io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfig build() {
        ControllerConfig buildable = new ControllerConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ControllerConfigBuilder that = (ControllerConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
