package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.DNS;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.ProxyStatus;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.Infrastructure;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class ControllerConfigSpecFluentImpl<A extends io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigSpecFluent<A> {

    private java.lang.String additionalTrustBundle;
    private java.lang.String cloudProviderCAData;
    private java.lang.String cloudProviderConfig;
    private java.lang.String clusterDNSIP;
    private io.fabric8.openshift.api.model.DNS dns;
    private java.lang.String etcdDiscoveryDomain;
    private java.util.Map<java.lang.String,java.lang.String> images;
    private io.fabric8.openshift.api.model.Infrastructure infra;
    private java.lang.String ipFamilies;
    private java.lang.String kubeAPIServerServingCAData;
    private java.lang.String networkType;
    private java.lang.String osImageURL;
    private java.lang.String platform;
    private io.fabric8.openshift.api.model.ProxyStatus proxy;
    private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder pullSecret;
    private java.lang.String releaseImage;
    private java.lang.String rootCAData;

    public ControllerConfigSpecFluentImpl() {
    }

    public ControllerConfigSpecFluentImpl(io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigSpec instance) {
        this.withAdditionalTrustBundle(instance.getAdditionalTrustBundle()); 
        this.withCloudProviderCAData(instance.getCloudProviderCAData()); 
        this.withCloudProviderConfig(instance.getCloudProviderConfig()); 
        this.withClusterDNSIP(instance.getClusterDNSIP()); 
        this.withDns(instance.getDns()); 
        this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain()); 
        this.withImages(instance.getImages()); 
        this.withInfra(instance.getInfra()); 
        this.withIpFamilies(instance.getIpFamilies()); 
        this.withKubeAPIServerServingCAData(instance.getKubeAPIServerServingCAData()); 
        this.withNetworkType(instance.getNetworkType()); 
        this.withOsImageURL(instance.getOsImageURL()); 
        this.withPlatform(instance.getPlatform()); 
        this.withProxy(instance.getProxy()); 
        this.withPullSecret(instance.getPullSecret()); 
        this.withReleaseImage(instance.getReleaseImage()); 
        this.withRootCAData(instance.getRootCAData()); 
    }

    public java.lang.String getAdditionalTrustBundle() {
        return this.additionalTrustBundle;
    }

    public A withAdditionalTrustBundle(java.lang.String additionalTrustBundle) {
        this.additionalTrustBundle=additionalTrustBundle; return (A) this;
    }

    public java.lang.Boolean hasAdditionalTrustBundle() {
        return this.additionalTrustBundle != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withAdditionalTrustBundle instead.
     */
        public A withNewAdditionalTrustBundle(java.lang.String arg0) {
        return (A)withAdditionalTrustBundle(new String(arg0));
    }

    public java.lang.String getCloudProviderCAData() {
        return this.cloudProviderCAData;
    }

    public A withCloudProviderCAData(java.lang.String cloudProviderCAData) {
        this.cloudProviderCAData=cloudProviderCAData; return (A) this;
    }

    public java.lang.Boolean hasCloudProviderCAData() {
        return this.cloudProviderCAData != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCloudProviderCAData instead.
     */
        public A withNewCloudProviderCAData(java.lang.String arg0) {
        return (A)withCloudProviderCAData(new String(arg0));
    }

    public java.lang.String getCloudProviderConfig() {
        return this.cloudProviderConfig;
    }

    public A withCloudProviderConfig(java.lang.String cloudProviderConfig) {
        this.cloudProviderConfig=cloudProviderConfig; return (A) this;
    }

    public java.lang.Boolean hasCloudProviderConfig() {
        return this.cloudProviderConfig != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCloudProviderConfig instead.
     */
        public A withNewCloudProviderConfig(java.lang.String arg0) {
        return (A)withCloudProviderConfig(new String(arg0));
    }

    public java.lang.String getClusterDNSIP() {
        return this.clusterDNSIP;
    }

    public A withClusterDNSIP(java.lang.String clusterDNSIP) {
        this.clusterDNSIP=clusterDNSIP; return (A) this;
    }

    public java.lang.Boolean hasClusterDNSIP() {
        return this.clusterDNSIP != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClusterDNSIP instead.
     */
        public A withNewClusterDNSIP(java.lang.String arg0) {
        return (A)withClusterDNSIP(new String(arg0));
    }

    public io.fabric8.openshift.api.model.DNS getDns() {
        return this.dns;
    }

    public A withDns(io.fabric8.openshift.api.model.DNS dns) {
        this.dns=dns; return (A) this;
    }

    public java.lang.Boolean hasDns() {
        return this.dns != null;
    }

    public java.lang.String getEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain;
    }

    public A withEtcdDiscoveryDomain(java.lang.String etcdDiscoveryDomain) {
        this.etcdDiscoveryDomain=etcdDiscoveryDomain; return (A) this;
    }

    public java.lang.Boolean hasEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withEtcdDiscoveryDomain instead.
     */
        public A withNewEtcdDiscoveryDomain(java.lang.String arg0) {
        return (A)withEtcdDiscoveryDomain(new String(arg0));
    }

    public A addToImages(java.lang.String key,java.lang.String value) {
        if(this.images == null && key != null && value != null) { this.images = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.images.put(key, value);} return (A)this;
    }

    public A addToImages(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.images == null && map != null) { this.images = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.images.putAll(map);} return (A)this;
    }

    public A removeFromImages(java.lang.String key) {
        if(this.images == null) { return (A) this; }
        if(key != null && this.images != null) {this.images.remove(key);} return (A)this;
    }

    public A removeFromImages(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.images == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.images != null){this.images.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getImages() {
        return this.images;
    }

    public <K,V>A withImages(java.util.Map<java.lang.String,java.lang.String> images) {
        if (images == null) { this.images =  null;} else {this.images = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(images);} return (A) this;
    }

    public java.lang.Boolean hasImages() {
        return this.images != null;
    }

    public io.fabric8.openshift.api.model.Infrastructure getInfra() {
        return this.infra;
    }

    public A withInfra(io.fabric8.openshift.api.model.Infrastructure infra) {
        this.infra=infra; return (A) this;
    }

    public java.lang.Boolean hasInfra() {
        return this.infra != null;
    }

    public java.lang.String getIpFamilies() {
        return this.ipFamilies;
    }

    public A withIpFamilies(java.lang.String ipFamilies) {
        this.ipFamilies=ipFamilies; return (A) this;
    }

    public java.lang.Boolean hasIpFamilies() {
        return this.ipFamilies != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withIpFamilies instead.
     */
        public A withNewIpFamilies(java.lang.String arg0) {
        return (A)withIpFamilies(new String(arg0));
    }

    public java.lang.String getKubeAPIServerServingCAData() {
        return this.kubeAPIServerServingCAData;
    }

    public A withKubeAPIServerServingCAData(java.lang.String kubeAPIServerServingCAData) {
        this.kubeAPIServerServingCAData=kubeAPIServerServingCAData; return (A) this;
    }

    public java.lang.Boolean hasKubeAPIServerServingCAData() {
        return this.kubeAPIServerServingCAData != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKubeAPIServerServingCAData instead.
     */
        public A withNewKubeAPIServerServingCAData(java.lang.String arg0) {
        return (A)withKubeAPIServerServingCAData(new String(arg0));
    }

    public java.lang.String getNetworkType() {
        return this.networkType;
    }

    public A withNetworkType(java.lang.String networkType) {
        this.networkType=networkType; return (A) this;
    }

    public java.lang.Boolean hasNetworkType() {
        return this.networkType != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withNetworkType instead.
     */
        public A withNewNetworkType(java.lang.String arg0) {
        return (A)withNetworkType(new String(arg0));
    }

    public java.lang.String getOsImageURL() {
        return this.osImageURL;
    }

    public A withOsImageURL(java.lang.String osImageURL) {
        this.osImageURL=osImageURL; return (A) this;
    }

    public java.lang.Boolean hasOsImageURL() {
        return this.osImageURL != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withOsImageURL instead.
     */
        public A withNewOsImageURL(java.lang.String arg0) {
        return (A)withOsImageURL(new String(arg0));
    }

    public java.lang.String getPlatform() {
        return this.platform;
    }

    public A withPlatform(java.lang.String platform) {
        this.platform=platform; return (A) this;
    }

    public java.lang.Boolean hasPlatform() {
        return this.platform != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPlatform instead.
     */
        public A withNewPlatform(java.lang.String arg0) {
        return (A)withPlatform(new String(arg0));
    }

    public io.fabric8.openshift.api.model.ProxyStatus getProxy() {
        return this.proxy;
    }

    public A withProxy(io.fabric8.openshift.api.model.ProxyStatus proxy) {
        this.proxy=proxy; return (A) this;
    }

    public java.lang.Boolean hasProxy() {
        return this.proxy != null;
    }

    public A withNewProxy(java.lang.String httpProxy,java.lang.String httpsProxy,java.lang.String noProxy) {
        return (A)withProxy(new ProxyStatus(httpProxy, httpsProxy, noProxy));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPullSecret instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectReference getPullSecret() {
        return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildPullSecret() {
        return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public A withPullSecret(io.fabric8.kubernetes.api.model.ObjectReference pullSecret) {
        _visitables.get("pullSecret").remove(this.pullSecret);
        if (pullSecret!=null){ this.pullSecret= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(pullSecret); _visitables.get("pullSecret").add(this.pullSecret);} return (A) this;
    }

    public java.lang.Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigSpecFluent.PullSecretNested<A> withNewPullSecret() {
        return new io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigSpecFluentImpl.PullSecretNestedImpl();
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigSpecFluent.PullSecretNested<A> withNewPullSecretLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigSpecFluentImpl.PullSecretNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigSpecFluent.PullSecretNested<A> editPullSecret() {
        return withNewPullSecretLike(getPullSecret());
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigSpecFluent.PullSecretNested<A> editOrNewPullSecret() {
        return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigSpecFluent.PullSecretNested<A> editOrNewPullSecretLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
    }

    public java.lang.String getReleaseImage() {
        return this.releaseImage;
    }

    public A withReleaseImage(java.lang.String releaseImage) {
        this.releaseImage=releaseImage; return (A) this;
    }

    public java.lang.Boolean hasReleaseImage() {
        return this.releaseImage != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withReleaseImage instead.
     */
        public A withNewReleaseImage(java.lang.String arg0) {
        return (A)withReleaseImage(new String(arg0));
    }

    public java.lang.String getRootCAData() {
        return this.rootCAData;
    }

    public A withRootCAData(java.lang.String rootCAData) {
        this.rootCAData=rootCAData; return (A) this;
    }

    public java.lang.Boolean hasRootCAData() {
        return this.rootCAData != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withRootCAData instead.
     */
        public A withNewRootCAData(java.lang.String arg0) {
        return (A)withRootCAData(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ControllerConfigSpecFluentImpl that = (ControllerConfigSpecFluentImpl) o;
        if (additionalTrustBundle != null ? !additionalTrustBundle.equals(that.additionalTrustBundle) :that.additionalTrustBundle != null) return false;
        if (cloudProviderCAData != null ? !cloudProviderCAData.equals(that.cloudProviderCAData) :that.cloudProviderCAData != null) return false;
        if (cloudProviderConfig != null ? !cloudProviderConfig.equals(that.cloudProviderConfig) :that.cloudProviderConfig != null) return false;
        if (clusterDNSIP != null ? !clusterDNSIP.equals(that.clusterDNSIP) :that.clusterDNSIP != null) return false;
        if (dns != null ? !dns.equals(that.dns) :that.dns != null) return false;
        if (etcdDiscoveryDomain != null ? !etcdDiscoveryDomain.equals(that.etcdDiscoveryDomain) :that.etcdDiscoveryDomain != null) return false;
        if (images != null ? !images.equals(that.images) :that.images != null) return false;
        if (infra != null ? !infra.equals(that.infra) :that.infra != null) return false;
        if (ipFamilies != null ? !ipFamilies.equals(that.ipFamilies) :that.ipFamilies != null) return false;
        if (kubeAPIServerServingCAData != null ? !kubeAPIServerServingCAData.equals(that.kubeAPIServerServingCAData) :that.kubeAPIServerServingCAData != null) return false;
        if (networkType != null ? !networkType.equals(that.networkType) :that.networkType != null) return false;
        if (osImageURL != null ? !osImageURL.equals(that.osImageURL) :that.osImageURL != null) return false;
        if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
        if (proxy != null ? !proxy.equals(that.proxy) :that.proxy != null) return false;
        if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
        if (releaseImage != null ? !releaseImage.equals(that.releaseImage) :that.releaseImage != null) return false;
        if (rootCAData != null ? !rootCAData.equals(that.rootCAData) :that.rootCAData != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(additionalTrustBundle,  cloudProviderCAData,  cloudProviderConfig,  clusterDNSIP,  dns,  etcdDiscoveryDomain,  images,  infra,  ipFamilies,  kubeAPIServerServingCAData,  networkType,  osImageURL,  platform,  proxy,  pullSecret,  releaseImage,  rootCAData,  super.hashCode());
    }

    public class PullSecretNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigSpecFluent.PullSecretNested<N>> implements io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigSpecFluent.PullSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;

            PullSecretNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
                        
            }

            PullSecretNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerConfigSpecFluentImpl.this.withPullSecret(builder.build());
            }

            public N endPullSecret() {
                return and();
            }
    }


}
