package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeletConfigBuilder extends io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigFluentImpl<io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfig,io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigBuilder> {

    io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KubeletConfigBuilder() {
        this(true);
    }

    public KubeletConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new KubeletConfig(), validationEnabled);
    }

    public KubeletConfigBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public KubeletConfigBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KubeletConfig(), validationEnabled);
    }

    public KubeletConfigBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigFluent<?> fluent,io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfig instance) {
        this(fluent, instance, true);
    }

    public KubeletConfigBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigFluent<?> fluent,io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeletConfigBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfig instance) {
        this(instance,true);
    }

    public KubeletConfigBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfig build() {
        KubeletConfig buildable = new KubeletConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubeletConfigBuilder that = (KubeletConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
