package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeletConfigListBuilder extends io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigListFluentImpl<io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigList,io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigListBuilder> {

    io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KubeletConfigListBuilder() {
        this(true);
    }

    public KubeletConfigListBuilder(java.lang.Boolean validationEnabled) {
        this(new KubeletConfigList(), validationEnabled);
    }

    public KubeletConfigListBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigListFluent<?> fluent) {
        this(fluent, true);
    }

    public KubeletConfigListBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KubeletConfigList(), validationEnabled);
    }

    public KubeletConfigListBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigListFluent<?> fluent,io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigList instance) {
        this(fluent, instance, true);
    }

    public KubeletConfigListBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigListFluent<?> fluent,io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeletConfigListBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigList instance) {
        this(instance,true);
    }

    public KubeletConfigListBuilder(io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigList build() {
        KubeletConfigList buildable = new KubeletConfigList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubeletConfigListBuilder that = (KubeletConfigListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
