package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class MachineConfigPoolStatusConfigurationFluentImpl<A extends io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluent<A> {

    private java.lang.String apiVersion;
    private java.lang.String fieldPath;
    private java.lang.String kind;
    private java.lang.String name;
    private java.lang.String namespace;
    private java.lang.String resourceVersion;
    private java.util.List<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> source =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();
    private java.lang.String uid;

    public MachineConfigPoolStatusConfigurationFluentImpl() {
    }

    public MachineConfigPoolStatusConfigurationFluentImpl(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfiguration instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withFieldPath(instance.getFieldPath()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.withResourceVersion(instance.getResourceVersion()); 
        this.withSource(instance.getSource()); 
        this.withUid(instance.getUid()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public java.lang.String getFieldPath() {
        return this.fieldPath;
    }

    public A withFieldPath(java.lang.String fieldPath) {
        this.fieldPath=fieldPath; return (A) this;
    }

    public java.lang.Boolean hasFieldPath() {
        return this.fieldPath != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFieldPath instead.
     */
        public A withNewFieldPath(java.lang.String arg0) {
        return (A)withFieldPath(new String(arg0));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    public java.lang.String getName() {
        return this.name;
    }

    public A withName(java.lang.String name) {
        this.name=name; return (A) this;
    }

    public java.lang.Boolean hasName() {
        return this.name != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String arg0) {
        return (A)withName(new String(arg0));
    }

    public java.lang.String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(java.lang.String namespace) {
        this.namespace=namespace; return (A) this;
    }

    public java.lang.Boolean hasNamespace() {
        return this.namespace != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withNamespace instead.
     */
        public A withNewNamespace(java.lang.String arg0) {
        return (A)withNamespace(new String(arg0));
    }

    public java.lang.String getResourceVersion() {
        return this.resourceVersion;
    }

    public A withResourceVersion(java.lang.String resourceVersion) {
        this.resourceVersion=resourceVersion; return (A) this;
    }

    public java.lang.Boolean hasResourceVersion() {
        return this.resourceVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withResourceVersion instead.
     */
        public A withNewResourceVersion(java.lang.String arg0) {
        return (A)withResourceVersion(new String(arg0));
    }

    public A addToSource(int index,io.fabric8.kubernetes.api.model.ObjectReference item) {
        if (this.source == null) {this.source = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();}
        io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("source").add(index >= 0 ? index : _visitables.get("source").size(), builder);this.source.add(index >= 0 ? index : source.size(), builder); return (A)this;
    }

    public A setToSource(int index,io.fabric8.kubernetes.api.model.ObjectReference item) {
        if (this.source == null) {this.source = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();}
        io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);
        if (index < 0 || index >= _visitables.get("source").size()) { _visitables.get("source").add(builder); } else { _visitables.get("source").set(index, builder);}
        if (index < 0 || index >= source.size()) { source.add(builder); } else { source.set(index, builder);}
         return (A)this;
    }

    public A addToSource(io.fabric8.kubernetes.api.model.ObjectReference... items) {
        if (this.source == null) {this.source = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();}
        for (io.fabric8.kubernetes.api.model.ObjectReference item : items) {io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("source").add(builder);this.source.add(builder);} return (A)this;
    }

    public A addAllToSource(java.util.Collection<io.fabric8.kubernetes.api.model.ObjectReference> items) {
        if (this.source == null) {this.source = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();}
        for (io.fabric8.kubernetes.api.model.ObjectReference item : items) {io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("source").add(builder);this.source.add(builder);} return (A)this;
    }

    public A removeFromSource(io.fabric8.kubernetes.api.model.ObjectReference... items) {
        for (io.fabric8.kubernetes.api.model.ObjectReference item : items) {io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("source").remove(builder);if (this.source != null) {this.source.remove(builder);}} return (A)this;
    }

    public A removeAllFromSource(java.util.Collection<io.fabric8.kubernetes.api.model.ObjectReference> items) {
        for (io.fabric8.kubernetes.api.model.ObjectReference item : items) {io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("source").remove(builder);if (this.source != null) {this.source.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSource(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate) {
        if (source == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> each = source.iterator();
        final List visitables = _visitables.get("source");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSource instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.ObjectReference> getSource() {
        return build(source);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.ObjectReference> buildSource() {
        return build(source);
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildSource(int index) {
        return this.source.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildFirstSource() {
        return this.source.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildLastSource() {
        return this.source.get(source.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildMatchingSource(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.ObjectReferenceBuilder item: source) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingSource(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.ObjectReferenceBuilder item: source) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSource(java.util.List<io.fabric8.kubernetes.api.model.ObjectReference> source) {
        if (this.source != null) { _visitables.get("source").removeAll(this.source);}
        if (source != null) {this.source = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>(); for (io.fabric8.kubernetes.api.model.ObjectReference item : source){this.addToSource(item);}} else { this.source = null;} return (A) this;
    }

    public A withSource(io.fabric8.kubernetes.api.model.ObjectReference... source) {
        if (this.source != null) {this.source.clear();}
        if (source != null) {for (io.fabric8.kubernetes.api.model.ObjectReference item :source){ this.addToSource(item);}} return (A) this;
    }

    public java.lang.Boolean hasSource() {
        return source != null && !source.isEmpty();
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluent.SourceNested<A> addNewSource() {
        return new io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluentImpl.SourceNestedImpl();
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluent.SourceNested<A> addNewSourceLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluentImpl.SourceNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluent.SourceNested<A> setNewSourceLike(int index,io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluentImpl.SourceNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluent.SourceNested<A> editSource(int index) {
        if (source.size() <= index) throw new RuntimeException("Can't edit source. Index exceeds size.");
        return setNewSourceLike(index, buildSource(index));
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluent.SourceNested<A> editFirstSource() {
        if (source.size() == 0) throw new RuntimeException("Can't edit first source. The list is empty.");
        return setNewSourceLike(0, buildSource(0));
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluent.SourceNested<A> editLastSource() {
        int index = source.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last source. The list is empty.");
        return setNewSourceLike(index, buildSource(index));
    }

    public io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluent.SourceNested<A> editMatchingSource(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<source.size();i++) { 
        if (predicate.test(source.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching source. No match found.");
        return setNewSourceLike(index, buildSource(index));
    }

    public java.lang.String getUid() {
        return this.uid;
    }

    public A withUid(java.lang.String uid) {
        this.uid=uid; return (A) this;
    }

    public java.lang.Boolean hasUid() {
        return this.uid != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUid instead.
     */
        public A withNewUid(java.lang.String arg0) {
        return (A)withUid(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MachineConfigPoolStatusConfigurationFluentImpl that = (MachineConfigPoolStatusConfigurationFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (fieldPath != null ? !fieldPath.equals(that.fieldPath) :that.fieldPath != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
        if (resourceVersion != null ? !resourceVersion.equals(that.resourceVersion) :that.resourceVersion != null) return false;
        if (source != null ? !source.equals(that.source) :that.source != null) return false;
        if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  fieldPath,  kind,  name,  namespace,  resourceVersion,  source,  uid,  super.hashCode());
    }

    public class SourceNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluent.SourceNested<N>> implements io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluent.SourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
        private final int index;

            SourceNestedImpl(int index,io.fabric8.kubernetes.api.model.ObjectReference item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
                        
            }

            SourceNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) MachineConfigPoolStatusConfigurationFluentImpl.this.setToSource(index,builder.build());
            }

            public N endSource() {
                return and();
            }
    }


}
