package io.fabric8.openshift.api.model.machineconfig.v1;

import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class MachineConfigSpecFluentImpl<A extends io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpecFluent<A> {

    private java.util.Map<java.lang.String,java.lang.Object> config;
    private java.util.List<java.lang.String> extensions = new java.util.ArrayList<java.lang.String>();
    private java.lang.Boolean fips;
    private java.util.List<java.lang.String> kernelArguments = new java.util.ArrayList<java.lang.String>();
    private java.lang.String kernelType;
    private java.lang.String osImageURL;

    public MachineConfigSpecFluentImpl() {
    }

    public MachineConfigSpecFluentImpl(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpec instance) {
        this.withConfig(instance.getConfig()); 
        this.withExtensions(instance.getExtensions()); 
        this.withFips(instance.getFips()); 
        this.withKernelArguments(instance.getKernelArguments()); 
        this.withKernelType(instance.getKernelType()); 
        this.withOsImageURL(instance.getOsImageURL()); 
    }

    public A addToConfig(java.lang.String key,java.lang.Object value) {
        if(this.config == null && key != null && value != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null && map != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(java.lang.String key) {
        if(this.config == null) { return (A) this; }
        if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.Object> getConfig() {
        return this.config;
    }

    public <K,V>A withConfig(java.util.Map<java.lang.String,java.lang.Object> config) {
        if (config == null) { this.config =  null;} else {this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(config);} return (A) this;
    }

    public java.lang.Boolean hasConfig() {
        return this.config != null;
    }

    public A addToExtensions(int index,java.lang.String item) {
        if (this.extensions == null) {this.extensions = new java.util.ArrayList<java.lang.String>();}
        this.extensions.add(index, item);
        return (A)this;
    }

    public A setToExtensions(int index,java.lang.String item) {
        if (this.extensions == null) {this.extensions = new java.util.ArrayList<java.lang.String>();}
        this.extensions.set(index, item); return (A)this;
    }

    public A addToExtensions(java.lang.String... items) {
        if (this.extensions == null) {this.extensions = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.extensions.add(item);} return (A)this;
    }

    public A addAllToExtensions(java.util.Collection<java.lang.String> items) {
        if (this.extensions == null) {this.extensions = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.extensions.add(item);} return (A)this;
    }

    public A removeFromExtensions(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.extensions!= null){ this.extensions.remove(item);}} return (A)this;
    }

    public A removeAllFromExtensions(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.extensions!= null){ this.extensions.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getExtensions() {
        return this.extensions;
    }

    public java.lang.String getExtension(int index) {
        return this.extensions.get(index);
    }

    public java.lang.String getFirstExtension() {
        return this.extensions.get(0);
    }

    public java.lang.String getLastExtension() {
        return this.extensions.get(extensions.size() - 1);
    }

    public java.lang.String getMatchingExtension(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: extensions) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingExtension(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: extensions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withExtensions(java.util.List<java.lang.String> extensions) {
        if (this.extensions != null) { _visitables.get("extensions").removeAll(this.extensions);}
        if (extensions != null) {this.extensions = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : extensions){this.addToExtensions(item);}} else { this.extensions = null;} return (A) this;
    }

    public A withExtensions(java.lang.String... extensions) {
        if (this.extensions != null) {this.extensions.clear();}
        if (extensions != null) {for (java.lang.String item :extensions){ this.addToExtensions(item);}} return (A) this;
    }

    public java.lang.Boolean hasExtensions() {
        return extensions != null && !extensions.isEmpty();
    }

    public A addNewExtension(java.lang.String arg0) {
        return (A)addToExtensions(new String(arg0));
    }

    public java.lang.Boolean getFips() {
        return this.fips;
    }

    public A withFips(java.lang.Boolean fips) {
        this.fips=fips; return (A) this;
    }

    public java.lang.Boolean hasFips() {
        return this.fips != null;
    }

    public A addToKernelArguments(int index,java.lang.String item) {
        if (this.kernelArguments == null) {this.kernelArguments = new java.util.ArrayList<java.lang.String>();}
        this.kernelArguments.add(index, item);
        return (A)this;
    }

    public A setToKernelArguments(int index,java.lang.String item) {
        if (this.kernelArguments == null) {this.kernelArguments = new java.util.ArrayList<java.lang.String>();}
        this.kernelArguments.set(index, item); return (A)this;
    }

    public A addToKernelArguments(java.lang.String... items) {
        if (this.kernelArguments == null) {this.kernelArguments = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.kernelArguments.add(item);} return (A)this;
    }

    public A addAllToKernelArguments(java.util.Collection<java.lang.String> items) {
        if (this.kernelArguments == null) {this.kernelArguments = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.kernelArguments.add(item);} return (A)this;
    }

    public A removeFromKernelArguments(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.kernelArguments!= null){ this.kernelArguments.remove(item);}} return (A)this;
    }

    public A removeAllFromKernelArguments(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.kernelArguments!= null){ this.kernelArguments.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getKernelArguments() {
        return this.kernelArguments;
    }

    public java.lang.String getKernelArgument(int index) {
        return this.kernelArguments.get(index);
    }

    public java.lang.String getFirstKernelArgument() {
        return this.kernelArguments.get(0);
    }

    public java.lang.String getLastKernelArgument() {
        return this.kernelArguments.get(kernelArguments.size() - 1);
    }

    public java.lang.String getMatchingKernelArgument(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: kernelArguments) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingKernelArgument(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: kernelArguments) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withKernelArguments(java.util.List<java.lang.String> kernelArguments) {
        if (this.kernelArguments != null) { _visitables.get("kernelArguments").removeAll(this.kernelArguments);}
        if (kernelArguments != null) {this.kernelArguments = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : kernelArguments){this.addToKernelArguments(item);}} else { this.kernelArguments = null;} return (A) this;
    }

    public A withKernelArguments(java.lang.String... kernelArguments) {
        if (this.kernelArguments != null) {this.kernelArguments.clear();}
        if (kernelArguments != null) {for (java.lang.String item :kernelArguments){ this.addToKernelArguments(item);}} return (A) this;
    }

    public java.lang.Boolean hasKernelArguments() {
        return kernelArguments != null && !kernelArguments.isEmpty();
    }

    public A addNewKernelArgument(java.lang.String arg0) {
        return (A)addToKernelArguments(new String(arg0));
    }

    public java.lang.String getKernelType() {
        return this.kernelType;
    }

    public A withKernelType(java.lang.String kernelType) {
        this.kernelType=kernelType; return (A) this;
    }

    public java.lang.Boolean hasKernelType() {
        return this.kernelType != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKernelType instead.
     */
        public A withNewKernelType(java.lang.String arg0) {
        return (A)withKernelType(new String(arg0));
    }

    public java.lang.String getOsImageURL() {
        return this.osImageURL;
    }

    public A withOsImageURL(java.lang.String osImageURL) {
        this.osImageURL=osImageURL; return (A) this;
    }

    public java.lang.Boolean hasOsImageURL() {
        return this.osImageURL != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withOsImageURL instead.
     */
        public A withNewOsImageURL(java.lang.String arg0) {
        return (A)withOsImageURL(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MachineConfigSpecFluentImpl that = (MachineConfigSpecFluentImpl) o;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
        if (fips != null ? !fips.equals(that.fips) :that.fips != null) return false;
        if (kernelArguments != null ? !kernelArguments.equals(that.kernelArguments) :that.kernelArguments != null) return false;
        if (kernelType != null ? !kernelType.equals(that.kernelType) :that.kernelType != null) return false;
        if (osImageURL != null ? !osImageURL.equals(that.osImageURL) :that.osImageURL != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(config,  extensions,  fips,  kernelArguments,  kernelType,  osImageURL,  super.hashCode());
    }

}
