/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfig;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigFluent;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpec;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpecBuilder;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpecFluentImpl;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigStatus;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigStatusBuilder;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigStatusFluentImpl;
import java.util.Objects;

public class KubeletConfigFluentImpl<A extends KubeletConfigFluent<A>>
extends BaseFluent<A>
implements KubeletConfigFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private KubeletConfigSpecBuilder spec;
    private KubeletConfigStatusBuilder status;

    public KubeletConfigFluentImpl() {
    }

    public KubeletConfigFluentImpl(KubeletConfig instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public KubeletConfigFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public KubeletConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public KubeletConfigFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public KubeletConfigFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public KubeletConfigFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public KubeletConfigSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public KubeletConfigSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(KubeletConfigSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new KubeletConfigSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public KubeletConfigFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public KubeletConfigFluent.SpecNested<A> withNewSpecLike(KubeletConfigSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public KubeletConfigFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public KubeletConfigFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new KubeletConfigSpecBuilder().build());
    }

    @Override
    public KubeletConfigFluent.SpecNested<A> editOrNewSpecLike(KubeletConfigSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public KubeletConfigStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public KubeletConfigStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(KubeletConfigStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new KubeletConfigStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public KubeletConfigFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public KubeletConfigFluent.StatusNested<A> withNewStatusLike(KubeletConfigStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public KubeletConfigFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public KubeletConfigFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new KubeletConfigStatusBuilder().build());
    }

    @Override
    public KubeletConfigFluent.StatusNested<A> editOrNewStatusLike(KubeletConfigStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubeletConfigFluentImpl that = (KubeletConfigFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends KubeletConfigStatusFluentImpl<KubeletConfigFluent.StatusNested<N>>
    implements KubeletConfigFluent.StatusNested<N>,
    Nested<N> {
        private final KubeletConfigStatusBuilder builder;

        StatusNestedImpl(KubeletConfigStatus item) {
            this.builder = new KubeletConfigStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new KubeletConfigStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)KubeletConfigFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends KubeletConfigSpecFluentImpl<KubeletConfigFluent.SpecNested<N>>
    implements KubeletConfigFluent.SpecNested<N>,
    Nested<N> {
        private final KubeletConfigSpecBuilder builder;

        SpecNestedImpl(KubeletConfigSpec item) {
            this.builder = new KubeletConfigSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new KubeletConfigSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)KubeletConfigFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<KubeletConfigFluent.MetadataNested<N>>
    implements KubeletConfigFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)KubeletConfigFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

