/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolSpec;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolSpecFluent;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolSpecFluentImpl;
import java.util.Objects;

public class MachineConfigPoolSpecBuilder
extends MachineConfigPoolSpecFluentImpl<MachineConfigPoolSpecBuilder>
implements VisitableBuilder<MachineConfigPoolSpec, MachineConfigPoolSpecBuilder> {
    MachineConfigPoolSpecFluent<?> fluent;
    Boolean validationEnabled;

    public MachineConfigPoolSpecBuilder() {
        this(true);
    }

    public MachineConfigPoolSpecBuilder(Boolean validationEnabled) {
        this(new MachineConfigPoolSpec(), validationEnabled);
    }

    public MachineConfigPoolSpecBuilder(MachineConfigPoolSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public MachineConfigPoolSpecBuilder(MachineConfigPoolSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new MachineConfigPoolSpec(), validationEnabled);
    }

    public MachineConfigPoolSpecBuilder(MachineConfigPoolSpecFluent<?> fluent, MachineConfigPoolSpec instance) {
        this(fluent, instance, true);
    }

    public MachineConfigPoolSpecBuilder(MachineConfigPoolSpecFluent<?> fluent, MachineConfigPoolSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConfiguration(instance.getConfiguration());
        fluent.withMachineConfigSelector(instance.getMachineConfigSelector());
        fluent.withMaxUnavailable(instance.getMaxUnavailable());
        fluent.withNodeSelector(instance.getNodeSelector());
        fluent.withPaused(instance.getPaused());
        this.validationEnabled = validationEnabled;
    }

    public MachineConfigPoolSpecBuilder(MachineConfigPoolSpec instance) {
        this(instance, (Boolean)true);
    }

    public MachineConfigPoolSpecBuilder(MachineConfigPoolSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConfiguration(instance.getConfiguration());
        this.withMachineConfigSelector(instance.getMachineConfigSelector());
        this.withMaxUnavailable(instance.getMaxUnavailable());
        this.withNodeSelector(instance.getNodeSelector());
        this.withPaused(instance.getPaused());
        this.validationEnabled = validationEnabled;
    }

    public MachineConfigPoolSpec build() {
        MachineConfigPoolSpec buildable = new MachineConfigPoolSpec(this.fluent.getConfiguration(), this.fluent.getMachineConfigSelector(), this.fluent.getMaxUnavailable(), this.fluent.getNodeSelector(), this.fluent.getPaused());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineConfigPoolSpecBuilder that = (MachineConfigPoolSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

