/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.openshift.api.model.TLSSecurityProfile;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpec;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class KubeletConfigSpecFluentImpl<A extends KubeletConfigSpecFluent<A>>
extends BaseFluent<A>
implements KubeletConfigSpecFluent<A> {
    private Boolean autoSizingReserved;
    private Map<String, Object> kubeletConfig;
    private Integer logLevel;
    private LabelSelectorBuilder machineConfigPoolSelector;
    private TLSSecurityProfile tlsSecurityProfile;

    public KubeletConfigSpecFluentImpl() {
    }

    public KubeletConfigSpecFluentImpl(KubeletConfigSpec instance) {
        this.withAutoSizingReserved(instance.getAutoSizingReserved());
        this.withKubeletConfig(instance.getKubeletConfig());
        this.withLogLevel(instance.getLogLevel());
        this.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector());
        this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
    }

    @Override
    public Boolean getAutoSizingReserved() {
        return this.autoSizingReserved;
    }

    @Override
    public A withAutoSizingReserved(Boolean autoSizingReserved) {
        this.autoSizingReserved = autoSizingReserved;
        return (A)this;
    }

    @Override
    public Boolean hasAutoSizingReserved() {
        return this.autoSizingReserved != null;
    }

    @Override
    public A addToKubeletConfig(String key, Object value) {
        if (this.kubeletConfig == null && key != null && value != null) {
            this.kubeletConfig = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.kubeletConfig.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToKubeletConfig(Map<String, Object> map) {
        if (this.kubeletConfig == null && map != null) {
            this.kubeletConfig = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.kubeletConfig.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromKubeletConfig(String key) {
        if (this.kubeletConfig == null) {
            return (A)this;
        }
        if (key != null && this.kubeletConfig != null) {
            this.kubeletConfig.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromKubeletConfig(Map<String, Object> map) {
        if (this.kubeletConfig == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.kubeletConfig == null) continue;
                this.kubeletConfig.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getKubeletConfig() {
        return this.kubeletConfig;
    }

    @Override
    public <K, V> A withKubeletConfig(Map<String, Object> kubeletConfig) {
        this.kubeletConfig = kubeletConfig == null ? null : new LinkedHashMap<String, Object>(kubeletConfig);
        return (A)this;
    }

    @Override
    public Boolean hasKubeletConfig() {
        return this.kubeletConfig != null;
    }

    @Override
    public Integer getLogLevel() {
        return this.logLevel;
    }

    @Override
    public A withLogLevel(Integer logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    @Override
    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    @Override
    @Deprecated
    public LabelSelector getMachineConfigPoolSelector() {
        return this.machineConfigPoolSelector != null ? this.machineConfigPoolSelector.build() : null;
    }

    @Override
    public LabelSelector buildMachineConfigPoolSelector() {
        return this.machineConfigPoolSelector != null ? this.machineConfigPoolSelector.build() : null;
    }

    @Override
    public A withMachineConfigPoolSelector(LabelSelector machineConfigPoolSelector) {
        this._visitables.get((Object)"machineConfigPoolSelector").remove(this.machineConfigPoolSelector);
        if (machineConfigPoolSelector != null) {
            this.machineConfigPoolSelector = new LabelSelectorBuilder(machineConfigPoolSelector);
            this._visitables.get((Object)"machineConfigPoolSelector").add(this.machineConfigPoolSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMachineConfigPoolSelector() {
        return this.machineConfigPoolSelector != null;
    }

    @Override
    public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> withNewMachineConfigPoolSelector() {
        return new MachineConfigPoolSelectorNestedImpl();
    }

    @Override
    public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> withNewMachineConfigPoolSelectorLike(LabelSelector item) {
        return new MachineConfigPoolSelectorNestedImpl(item);
    }

    @Override
    public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> editMachineConfigPoolSelector() {
        return this.withNewMachineConfigPoolSelectorLike(this.getMachineConfigPoolSelector());
    }

    @Override
    public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> editOrNewMachineConfigPoolSelector() {
        return this.withNewMachineConfigPoolSelectorLike(this.getMachineConfigPoolSelector() != null ? this.getMachineConfigPoolSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> editOrNewMachineConfigPoolSelectorLike(LabelSelector item) {
        return this.withNewMachineConfigPoolSelectorLike(this.getMachineConfigPoolSelector() != null ? this.getMachineConfigPoolSelector() : item);
    }

    @Override
    public TLSSecurityProfile getTlsSecurityProfile() {
        return this.tlsSecurityProfile;
    }

    @Override
    public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile) {
        this.tlsSecurityProfile = tlsSecurityProfile;
        return (A)this;
    }

    @Override
    public Boolean hasTlsSecurityProfile() {
        return this.tlsSecurityProfile != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubeletConfigSpecFluentImpl that = (KubeletConfigSpecFluentImpl)o;
        if (this.autoSizingReserved != null ? !this.autoSizingReserved.equals(that.autoSizingReserved) : that.autoSizingReserved != null) {
            return false;
        }
        if (this.kubeletConfig != null ? !this.kubeletConfig.equals(that.kubeletConfig) : that.kubeletConfig != null) {
            return false;
        }
        if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) {
            return false;
        }
        if (this.machineConfigPoolSelector != null ? !this.machineConfigPoolSelector.equals((Object)that.machineConfigPoolSelector) : that.machineConfigPoolSelector != null) {
            return false;
        }
        return !(this.tlsSecurityProfile != null ? !this.tlsSecurityProfile.equals((Object)that.tlsSecurityProfile) : that.tlsSecurityProfile != null);
    }

    public int hashCode() {
        return Objects.hash(this.autoSizingReserved, this.kubeletConfig, this.logLevel, this.machineConfigPoolSelector, this.tlsSecurityProfile, super.hashCode());
    }

    public class MachineConfigPoolSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<N>>
    implements KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        MachineConfigPoolSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        MachineConfigPoolSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)KubeletConfigSpecFluentImpl.this.withMachineConfigPoolSelector(this.builder.build());
        }

        @Override
        public N endMachineConfigPoolSelector() {
            return this.and();
        }
    }
}

