package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class MachineConfigSpecBuilder extends io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpecFluentImpl<io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpec,io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpecBuilder>{
  public MachineConfigSpecBuilder() {
    this(false);
  }
  public MachineConfigSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new MachineConfigSpec(), validationEnabled);
  }
  public MachineConfigSpecBuilder(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineConfigSpecBuilder(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new MachineConfigSpec(), validationEnabled);
  }
  public MachineConfigSpecBuilder(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpecFluent<?> fluent,io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpec instance) {
    this(fluent, instance, false);
  }
  public MachineConfigSpecBuilder(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpecFluent<?> fluent,io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfig(instance.getConfig()); 
    fluent.withExtensions(instance.getExtensions()); 
    fluent.withFips(instance.getFips()); 
    fluent.withKernelArguments(instance.getKernelArguments()); 
    fluent.withKernelType(instance.getKernelType()); 
    fluent.withOsImageURL(instance.getOsImageURL()); 
    this.validationEnabled = validationEnabled; 
  }
  public MachineConfigSpecBuilder(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpec instance) {
    this(instance,false);
  }
  public MachineConfigSpecBuilder(io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfig(instance.getConfig()); 
    this.withExtensions(instance.getExtensions()); 
    this.withFips(instance.getFips()); 
    this.withKernelArguments(instance.getKernelArguments()); 
    this.withKernelType(instance.getKernelType()); 
    this.withOsImageURL(instance.getOsImageURL()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpec build() {
    MachineConfigSpec buildable = new MachineConfigSpec(fluent.getConfig(),fluent.getExtensions(),fluent.getFips(),fluent.getKernelArguments(),fluent.getKernelType(),fluent.getOsImageURL());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineConfigSpecBuilder that = (MachineConfigSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}