package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ControllerConfigStatusConditionBuilder extends ControllerConfigStatusConditionFluentImpl<ControllerConfigStatusConditionBuilder> implements VisitableBuilder<ControllerConfigStatusCondition,ControllerConfigStatusConditionBuilder>{
  public ControllerConfigStatusConditionBuilder() {
    this(false);
  }
  public ControllerConfigStatusConditionBuilder(Boolean validationEnabled) {
    this(new ControllerConfigStatusCondition(), validationEnabled);
  }
  public ControllerConfigStatusConditionBuilder(ControllerConfigStatusConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ControllerConfigStatusConditionBuilder(ControllerConfigStatusConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ControllerConfigStatusCondition(), validationEnabled);
  }
  public ControllerConfigStatusConditionBuilder(ControllerConfigStatusConditionFluent<?> fluent,ControllerConfigStatusCondition instance) {
    this(fluent, instance, false);
  }
  public ControllerConfigStatusConditionBuilder(ControllerConfigStatusConditionFluent<?> fluent,ControllerConfigStatusCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ControllerConfigStatusConditionBuilder(ControllerConfigStatusCondition instance) {
    this(instance,false);
  }
  public ControllerConfigStatusConditionBuilder(ControllerConfigStatusCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ControllerConfigStatusConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ControllerConfigStatusCondition build() {
    ControllerConfigStatusCondition buildable = new ControllerConfigStatusCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}