package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeletConfigSpecBuilder extends KubeletConfigSpecFluentImpl<KubeletConfigSpecBuilder> implements VisitableBuilder<KubeletConfigSpec,KubeletConfigSpecBuilder>{
  public KubeletConfigSpecBuilder() {
    this(false);
  }
  public KubeletConfigSpecBuilder(Boolean validationEnabled) {
    this(new KubeletConfigSpec(), validationEnabled);
  }
  public KubeletConfigSpecBuilder(KubeletConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeletConfigSpecBuilder(KubeletConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeletConfigSpec(), validationEnabled);
  }
  public KubeletConfigSpecBuilder(KubeletConfigSpecFluent<?> fluent,KubeletConfigSpec instance) {
    this(fluent, instance, false);
  }
  public KubeletConfigSpecBuilder(KubeletConfigSpecFluent<?> fluent,KubeletConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAutoSizingReserved(instance.getAutoSizingReserved()); 
    fluent.withKubeletConfig(instance.getKubeletConfig()); 
    fluent.withLogLevel(instance.getLogLevel()); 
    fluent.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector()); 
    fluent.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KubeletConfigSpecBuilder(KubeletConfigSpec instance) {
    this(instance,false);
  }
  public KubeletConfigSpecBuilder(KubeletConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAutoSizingReserved(instance.getAutoSizingReserved()); 
    this.withKubeletConfig(instance.getKubeletConfig()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector()); 
    this.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  KubeletConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KubeletConfigSpec build() {
    KubeletConfigSpec buildable = new KubeletConfigSpec(fluent.getAutoSizingReserved(),fluent.getKubeletConfig(),fluent.getLogLevel(),fluent.getMachineConfigPoolSelector(),fluent.getTlsSecurityProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}