package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeletConfigConditionBuilder extends KubeletConfigConditionFluent<KubeletConfigConditionBuilder> implements VisitableBuilder<KubeletConfigCondition,KubeletConfigConditionBuilder>{
  public KubeletConfigConditionBuilder() {
    this(false);
  }
  public KubeletConfigConditionBuilder(Boolean validationEnabled) {
    this(new KubeletConfigCondition(), validationEnabled);
  }
  public KubeletConfigConditionBuilder(KubeletConfigConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeletConfigConditionBuilder(KubeletConfigConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeletConfigCondition(), validationEnabled);
  }
  public KubeletConfigConditionBuilder(KubeletConfigConditionFluent<?> fluent,KubeletConfigCondition instance) {
    this(fluent, instance, false);
  }
  public KubeletConfigConditionBuilder(KubeletConfigConditionFluent<?> fluent,KubeletConfigCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KubeletConfigCondition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeletConfigConditionBuilder(KubeletConfigCondition instance) {
    this(instance,false);
  }
  public KubeletConfigConditionBuilder(KubeletConfigCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KubeletConfigCondition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeletConfigConditionFluent<?> fluent;
  Boolean validationEnabled;
  public KubeletConfigCondition build() {
    KubeletConfigCondition buildable = new KubeletConfigCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}