package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeletConfigListBuilder extends KubeletConfigListFluent<KubeletConfigListBuilder> implements VisitableBuilder<KubeletConfigList,KubeletConfigListBuilder>{
  public KubeletConfigListBuilder() {
    this(false);
  }
  public KubeletConfigListBuilder(Boolean validationEnabled) {
    this(new KubeletConfigList(), validationEnabled);
  }
  public KubeletConfigListBuilder(KubeletConfigListFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeletConfigListBuilder(KubeletConfigListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeletConfigList(), validationEnabled);
  }
  public KubeletConfigListBuilder(KubeletConfigListFluent<?> fluent,KubeletConfigList instance) {
    this(fluent, instance, false);
  }
  public KubeletConfigListBuilder(KubeletConfigListFluent<?> fluent,KubeletConfigList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KubeletConfigList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeletConfigListBuilder(KubeletConfigList instance) {
    this(instance,false);
  }
  public KubeletConfigListBuilder(KubeletConfigList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KubeletConfigList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeletConfigListFluent<?> fluent;
  Boolean validationEnabled;
  public KubeletConfigList build() {
    KubeletConfigList buildable = new KubeletConfigList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}