package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeletConfigStatusBuilder extends KubeletConfigStatusFluent<KubeletConfigStatusBuilder> implements VisitableBuilder<KubeletConfigStatus,KubeletConfigStatusBuilder>{
  public KubeletConfigStatusBuilder() {
    this(false);
  }
  public KubeletConfigStatusBuilder(Boolean validationEnabled) {
    this(new KubeletConfigStatus(), validationEnabled);
  }
  public KubeletConfigStatusBuilder(KubeletConfigStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeletConfigStatusBuilder(KubeletConfigStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeletConfigStatus(), validationEnabled);
  }
  public KubeletConfigStatusBuilder(KubeletConfigStatusFluent<?> fluent,KubeletConfigStatus instance) {
    this(fluent, instance, false);
  }
  public KubeletConfigStatusBuilder(KubeletConfigStatusFluent<?> fluent,KubeletConfigStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KubeletConfigStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeletConfigStatusBuilder(KubeletConfigStatus instance) {
    this(instance,false);
  }
  public KubeletConfigStatusBuilder(KubeletConfigStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KubeletConfigStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeletConfigStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KubeletConfigStatus build() {
    KubeletConfigStatus buildable = new KubeletConfigStatus(fluent.buildConditions(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}