package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineConfigListBuilder extends MachineConfigListFluent<MachineConfigListBuilder> implements VisitableBuilder<MachineConfigList,MachineConfigListBuilder>{
  public MachineConfigListBuilder() {
    this(false);
  }
  public MachineConfigListBuilder(Boolean validationEnabled) {
    this(new MachineConfigList(), validationEnabled);
  }
  public MachineConfigListBuilder(MachineConfigListFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineConfigListBuilder(MachineConfigListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineConfigList(), validationEnabled);
  }
  public MachineConfigListBuilder(MachineConfigListFluent<?> fluent,MachineConfigList instance) {
    this(fluent, instance, false);
  }
  public MachineConfigListBuilder(MachineConfigListFluent<?> fluent,MachineConfigList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachineConfigList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineConfigListBuilder(MachineConfigList instance) {
    this(instance,false);
  }
  public MachineConfigListBuilder(MachineConfigList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachineConfigList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineConfigListFluent<?> fluent;
  Boolean validationEnabled;
  public MachineConfigList build() {
    MachineConfigList buildable = new MachineConfigList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}