package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineConfigPoolConditionBuilder extends MachineConfigPoolConditionFluent<MachineConfigPoolConditionBuilder> implements VisitableBuilder<MachineConfigPoolCondition,MachineConfigPoolConditionBuilder>{
  public MachineConfigPoolConditionBuilder() {
    this(false);
  }
  public MachineConfigPoolConditionBuilder(Boolean validationEnabled) {
    this(new MachineConfigPoolCondition(), validationEnabled);
  }
  public MachineConfigPoolConditionBuilder(MachineConfigPoolConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineConfigPoolConditionBuilder(MachineConfigPoolConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineConfigPoolCondition(), validationEnabled);
  }
  public MachineConfigPoolConditionBuilder(MachineConfigPoolConditionFluent<?> fluent,MachineConfigPoolCondition instance) {
    this(fluent, instance, false);
  }
  public MachineConfigPoolConditionBuilder(MachineConfigPoolConditionFluent<?> fluent,MachineConfigPoolCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachineConfigPoolCondition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineConfigPoolConditionBuilder(MachineConfigPoolCondition instance) {
    this(instance,false);
  }
  public MachineConfigPoolConditionBuilder(MachineConfigPoolCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachineConfigPoolCondition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineConfigPoolConditionFluent<?> fluent;
  Boolean validationEnabled;
  public MachineConfigPoolCondition build() {
    MachineConfigPoolCondition buildable = new MachineConfigPoolCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}