package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ContainerRuntimeConfigSpecFluent<A extends ContainerRuntimeConfigSpecFluent<A>> extends BaseFluent<A>{
  public ContainerRuntimeConfigSpecFluent() {
  }
  
  public ContainerRuntimeConfigSpecFluent(ContainerRuntimeConfigSpec instance) {
    this.copyInstance(instance);
  }
  private ContainerRuntimeConfigurationBuilder containerRuntimeConfig;
  private LabelSelectorBuilder machineConfigPoolSelector;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ContainerRuntimeConfigSpec instance) {
    instance = (instance != null ? instance : new ContainerRuntimeConfigSpec());
    if (instance != null) {
          this.withContainerRuntimeConfig(instance.getContainerRuntimeConfig());
          this.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector());
          this.withContainerRuntimeConfig(instance.getContainerRuntimeConfig());
          this.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ContainerRuntimeConfiguration buildContainerRuntimeConfig() {
    return this.containerRuntimeConfig != null ? this.containerRuntimeConfig.build() : null;
  }
  
  public A withContainerRuntimeConfig(ContainerRuntimeConfiguration containerRuntimeConfig) {
    this._visitables.remove(this.containerRuntimeConfig);
    if (containerRuntimeConfig != null) {
        this.containerRuntimeConfig = new ContainerRuntimeConfigurationBuilder(containerRuntimeConfig);
        this._visitables.get("containerRuntimeConfig").add(this.containerRuntimeConfig);
    } else {
        this.containerRuntimeConfig = null;
        this._visitables.get("containerRuntimeConfig").remove(this.containerRuntimeConfig);
    }
    return (A) this;
  }
  
  public boolean hasContainerRuntimeConfig() {
    return this.containerRuntimeConfig != null;
  }
  
  public ContainerRuntimeConfigNested<A> withNewContainerRuntimeConfig() {
    return new ContainerRuntimeConfigNested(null);
  }
  
  public ContainerRuntimeConfigNested<A> withNewContainerRuntimeConfigLike(ContainerRuntimeConfiguration item) {
    return new ContainerRuntimeConfigNested(item);
  }
  
  public ContainerRuntimeConfigNested<A> editContainerRuntimeConfig() {
    return withNewContainerRuntimeConfigLike(java.util.Optional.ofNullable(buildContainerRuntimeConfig()).orElse(null));
  }
  
  public ContainerRuntimeConfigNested<A> editOrNewContainerRuntimeConfig() {
    return withNewContainerRuntimeConfigLike(java.util.Optional.ofNullable(buildContainerRuntimeConfig()).orElse(new ContainerRuntimeConfigurationBuilder().build()));
  }
  
  public ContainerRuntimeConfigNested<A> editOrNewContainerRuntimeConfigLike(ContainerRuntimeConfiguration item) {
    return withNewContainerRuntimeConfigLike(java.util.Optional.ofNullable(buildContainerRuntimeConfig()).orElse(item));
  }
  
  public LabelSelector buildMachineConfigPoolSelector() {
    return this.machineConfigPoolSelector != null ? this.machineConfigPoolSelector.build() : null;
  }
  
  public A withMachineConfigPoolSelector(LabelSelector machineConfigPoolSelector) {
    this._visitables.remove(this.machineConfigPoolSelector);
    if (machineConfigPoolSelector != null) {
        this.machineConfigPoolSelector = new LabelSelectorBuilder(machineConfigPoolSelector);
        this._visitables.get("machineConfigPoolSelector").add(this.machineConfigPoolSelector);
    } else {
        this.machineConfigPoolSelector = null;
        this._visitables.get("machineConfigPoolSelector").remove(this.machineConfigPoolSelector);
    }
    return (A) this;
  }
  
  public boolean hasMachineConfigPoolSelector() {
    return this.machineConfigPoolSelector != null;
  }
  
  public MachineConfigPoolSelectorNested<A> withNewMachineConfigPoolSelector() {
    return new MachineConfigPoolSelectorNested(null);
  }
  
  public MachineConfigPoolSelectorNested<A> withNewMachineConfigPoolSelectorLike(LabelSelector item) {
    return new MachineConfigPoolSelectorNested(item);
  }
  
  public MachineConfigPoolSelectorNested<A> editMachineConfigPoolSelector() {
    return withNewMachineConfigPoolSelectorLike(java.util.Optional.ofNullable(buildMachineConfigPoolSelector()).orElse(null));
  }
  
  public MachineConfigPoolSelectorNested<A> editOrNewMachineConfigPoolSelector() {
    return withNewMachineConfigPoolSelectorLike(java.util.Optional.ofNullable(buildMachineConfigPoolSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public MachineConfigPoolSelectorNested<A> editOrNewMachineConfigPoolSelectorLike(LabelSelector item) {
    return withNewMachineConfigPoolSelectorLike(java.util.Optional.ofNullable(buildMachineConfigPoolSelector()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerRuntimeConfigSpecFluent that = (ContainerRuntimeConfigSpecFluent) o;
    if (!java.util.Objects.equals(containerRuntimeConfig, that.containerRuntimeConfig)) return false;
    if (!java.util.Objects.equals(machineConfigPoolSelector, that.machineConfigPoolSelector)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(containerRuntimeConfig,  machineConfigPoolSelector,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerRuntimeConfig != null) { sb.append("containerRuntimeConfig:"); sb.append(containerRuntimeConfig + ","); }
    if (machineConfigPoolSelector != null) { sb.append("machineConfigPoolSelector:"); sb.append(machineConfigPoolSelector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ContainerRuntimeConfigNested<N> extends ContainerRuntimeConfigurationFluent<ContainerRuntimeConfigNested<N>> implements Nested<N>{
    ContainerRuntimeConfigNested(ContainerRuntimeConfiguration item) {
      this.builder = new ContainerRuntimeConfigurationBuilder(this, item);
    }
    ContainerRuntimeConfigurationBuilder builder;
    
    public N and() {
      return (N) ContainerRuntimeConfigSpecFluent.this.withContainerRuntimeConfig(builder.build());
    }
    
    public N endContainerRuntimeConfig() {
      return and();
    }
    
  
  }
  public class MachineConfigPoolSelectorNested<N> extends LabelSelectorFluent<MachineConfigPoolSelectorNested<N>> implements Nested<N>{
    MachineConfigPoolSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ContainerRuntimeConfigSpecFluent.this.withMachineConfigPoolSelector(builder.build());
    }
    
    public N endMachineConfigPoolSelector() {
      return and();
    }
    
  
  }

}