package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.openshift.api.model.config.v1.TLSSecurityProfile;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KubeletConfigSpecFluent<A extends KubeletConfigSpecFluent<A>> extends BaseFluent<A>{
  public KubeletConfigSpecFluent() {
  }
  
  public KubeletConfigSpecFluent(KubeletConfigSpec instance) {
    this.copyInstance(instance);
  }
  private Boolean autoSizingReserved;
  private Map<String,Object> kubeletConfig;
  private Integer logLevel;
  private LabelSelectorBuilder machineConfigPoolSelector;
  private TLSSecurityProfile tlsSecurityProfile;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(KubeletConfigSpec instance) {
    instance = (instance != null ? instance : new KubeletConfigSpec());
    if (instance != null) {
          this.withAutoSizingReserved(instance.getAutoSizingReserved());
          this.withKubeletConfig(instance.getKubeletConfig());
          this.withLogLevel(instance.getLogLevel());
          this.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector());
          this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
          this.withAutoSizingReserved(instance.getAutoSizingReserved());
          this.withKubeletConfig(instance.getKubeletConfig());
          this.withLogLevel(instance.getLogLevel());
          this.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector());
          this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getAutoSizingReserved() {
    return this.autoSizingReserved;
  }
  
  public A withAutoSizingReserved(Boolean autoSizingReserved) {
    this.autoSizingReserved = autoSizingReserved;
    return (A) this;
  }
  
  public boolean hasAutoSizingReserved() {
    return this.autoSizingReserved != null;
  }
  
  public A addToKubeletConfig(String key,Object value) {
    if(this.kubeletConfig == null && key != null && value != null) { this.kubeletConfig = new LinkedHashMap(); }
    if(key != null && value != null) {this.kubeletConfig.put(key, value);} return (A)this;
  }
  
  public A addToKubeletConfig(Map<String,Object> map) {
    if(this.kubeletConfig == null && map != null) { this.kubeletConfig = new LinkedHashMap(); }
    if(map != null) { this.kubeletConfig.putAll(map);} return (A)this;
  }
  
  public A removeFromKubeletConfig(String key) {
    if(this.kubeletConfig == null) { return (A) this; }
    if(key != null && this.kubeletConfig != null) {this.kubeletConfig.remove(key);} return (A)this;
  }
  
  public A removeFromKubeletConfig(Map<String,Object> map) {
    if(this.kubeletConfig == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.kubeletConfig != null){this.kubeletConfig.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getKubeletConfig() {
    return this.kubeletConfig;
  }
  
  public <K,V>A withKubeletConfig(Map<String,Object> kubeletConfig) {
    if (kubeletConfig == null) {
      this.kubeletConfig = null;
    } else {
      this.kubeletConfig = new LinkedHashMap(kubeletConfig);
    }
    return (A) this;
  }
  
  public boolean hasKubeletConfig() {
    return this.kubeletConfig != null;
  }
  
  public Integer getLogLevel() {
    return this.logLevel;
  }
  
  public A withLogLevel(Integer logLevel) {
    this.logLevel = logLevel;
    return (A) this;
  }
  
  public boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  public LabelSelector buildMachineConfigPoolSelector() {
    return this.machineConfigPoolSelector != null ? this.machineConfigPoolSelector.build() : null;
  }
  
  public A withMachineConfigPoolSelector(LabelSelector machineConfigPoolSelector) {
    this._visitables.remove(this.machineConfigPoolSelector);
    if (machineConfigPoolSelector != null) {
        this.machineConfigPoolSelector = new LabelSelectorBuilder(machineConfigPoolSelector);
        this._visitables.get("machineConfigPoolSelector").add(this.machineConfigPoolSelector);
    } else {
        this.machineConfigPoolSelector = null;
        this._visitables.get("machineConfigPoolSelector").remove(this.machineConfigPoolSelector);
    }
    return (A) this;
  }
  
  public boolean hasMachineConfigPoolSelector() {
    return this.machineConfigPoolSelector != null;
  }
  
  public MachineConfigPoolSelectorNested<A> withNewMachineConfigPoolSelector() {
    return new MachineConfigPoolSelectorNested(null);
  }
  
  public MachineConfigPoolSelectorNested<A> withNewMachineConfigPoolSelectorLike(LabelSelector item) {
    return new MachineConfigPoolSelectorNested(item);
  }
  
  public MachineConfigPoolSelectorNested<A> editMachineConfigPoolSelector() {
    return withNewMachineConfigPoolSelectorLike(java.util.Optional.ofNullable(buildMachineConfigPoolSelector()).orElse(null));
  }
  
  public MachineConfigPoolSelectorNested<A> editOrNewMachineConfigPoolSelector() {
    return withNewMachineConfigPoolSelectorLike(java.util.Optional.ofNullable(buildMachineConfigPoolSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public MachineConfigPoolSelectorNested<A> editOrNewMachineConfigPoolSelectorLike(LabelSelector item) {
    return withNewMachineConfigPoolSelectorLike(java.util.Optional.ofNullable(buildMachineConfigPoolSelector()).orElse(item));
  }
  
  public TLSSecurityProfile getTlsSecurityProfile() {
    return this.tlsSecurityProfile;
  }
  
  public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile) {
    this.tlsSecurityProfile = tlsSecurityProfile;
    return (A) this;
  }
  
  public boolean hasTlsSecurityProfile() {
    return this.tlsSecurityProfile != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubeletConfigSpecFluent that = (KubeletConfigSpecFluent) o;
    if (!java.util.Objects.equals(autoSizingReserved, that.autoSizingReserved)) return false;
    if (!java.util.Objects.equals(kubeletConfig, that.kubeletConfig)) return false;
    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;
    if (!java.util.Objects.equals(machineConfigPoolSelector, that.machineConfigPoolSelector)) return false;
    if (!java.util.Objects.equals(tlsSecurityProfile, that.tlsSecurityProfile)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(autoSizingReserved,  kubeletConfig,  logLevel,  machineConfigPoolSelector,  tlsSecurityProfile,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (autoSizingReserved != null) { sb.append("autoSizingReserved:"); sb.append(autoSizingReserved + ","); }
    if (kubeletConfig != null && !kubeletConfig.isEmpty()) { sb.append("kubeletConfig:"); sb.append(kubeletConfig + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (machineConfigPoolSelector != null) { sb.append("machineConfigPoolSelector:"); sb.append(machineConfigPoolSelector + ","); }
    if (tlsSecurityProfile != null) { sb.append("tlsSecurityProfile:"); sb.append(tlsSecurityProfile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAutoSizingReserved() {
    return withAutoSizingReserved(true);
  }
  public class MachineConfigPoolSelectorNested<N> extends LabelSelectorFluent<MachineConfigPoolSelectorNested<N>> implements Nested<N>{
    MachineConfigPoolSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) KubeletConfigSpecFluent.this.withMachineConfigPoolSelector(builder.build());
    }
    
    public N endMachineConfigPoolSelector() {
      return and();
    }
    
  
  }

}