package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineConfigPoolStatusFluent<A extends MachineConfigPoolStatusFluent<A>> extends BaseFluent<A>{
  public MachineConfigPoolStatusFluent() {
  }
  
  public MachineConfigPoolStatusFluent(MachineConfigPoolStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<CertExpiryBuilder> certExpirys = new ArrayList<CertExpiryBuilder>();
  private ArrayList<MachineConfigPoolConditionBuilder> conditions = new ArrayList<MachineConfigPoolConditionBuilder>();
  private MachineConfigPoolStatusConfigurationBuilder configuration;
  private Integer degradedMachineCount;
  private Integer machineCount;
  private Long observedGeneration;
  private ArrayList<PoolSynchronizerStatusBuilder> poolSynchronizersStatus = new ArrayList<PoolSynchronizerStatusBuilder>();
  private Integer readyMachineCount;
  private Integer unavailableMachineCount;
  private Integer updatedMachineCount;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineConfigPoolStatus instance) {
    instance = (instance != null ? instance : new MachineConfigPoolStatus());
    if (instance != null) {
          this.withCertExpirys(instance.getCertExpirys());
          this.withConditions(instance.getConditions());
          this.withConfiguration(instance.getConfiguration());
          this.withDegradedMachineCount(instance.getDegradedMachineCount());
          this.withMachineCount(instance.getMachineCount());
          this.withObservedGeneration(instance.getObservedGeneration());
          this.withPoolSynchronizersStatus(instance.getPoolSynchronizersStatus());
          this.withReadyMachineCount(instance.getReadyMachineCount());
          this.withUnavailableMachineCount(instance.getUnavailableMachineCount());
          this.withUpdatedMachineCount(instance.getUpdatedMachineCount());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToCertExpirys(int index,CertExpiry item) {
    if (this.certExpirys == null) {this.certExpirys = new ArrayList<CertExpiryBuilder>();}
    CertExpiryBuilder builder = new CertExpiryBuilder(item);
    if (index < 0 || index >= certExpirys.size()) { _visitables.get("certExpirys").add(builder); certExpirys.add(builder); } else { _visitables.get("certExpirys").add(index, builder); certExpirys.add(index, builder);}
    return (A)this;
  }
  
  public A setToCertExpirys(int index,CertExpiry item) {
    if (this.certExpirys == null) {this.certExpirys = new ArrayList<CertExpiryBuilder>();}
    CertExpiryBuilder builder = new CertExpiryBuilder(item);
    if (index < 0 || index >= certExpirys.size()) { _visitables.get("certExpirys").add(builder); certExpirys.add(builder); } else { _visitables.get("certExpirys").set(index, builder); certExpirys.set(index, builder);}
    return (A)this;
  }
  
  public A addToCertExpirys(io.fabric8.openshift.api.model.machineconfiguration.v1.CertExpiry... items) {
    if (this.certExpirys == null) {this.certExpirys = new ArrayList<CertExpiryBuilder>();}
    for (CertExpiry item : items) {CertExpiryBuilder builder = new CertExpiryBuilder(item);_visitables.get("certExpirys").add(builder);this.certExpirys.add(builder);} return (A)this;
  }
  
  public A addAllToCertExpirys(Collection<CertExpiry> items) {
    if (this.certExpirys == null) {this.certExpirys = new ArrayList<CertExpiryBuilder>();}
    for (CertExpiry item : items) {CertExpiryBuilder builder = new CertExpiryBuilder(item);_visitables.get("certExpirys").add(builder);this.certExpirys.add(builder);} return (A)this;
  }
  
  public A removeFromCertExpirys(io.fabric8.openshift.api.model.machineconfiguration.v1.CertExpiry... items) {
    if (this.certExpirys == null) return (A)this;
    for (CertExpiry item : items) {CertExpiryBuilder builder = new CertExpiryBuilder(item);_visitables.get("certExpirys").remove(builder); this.certExpirys.remove(builder);} return (A)this;
  }
  
  public A removeAllFromCertExpirys(Collection<CertExpiry> items) {
    if (this.certExpirys == null) return (A)this;
    for (CertExpiry item : items) {CertExpiryBuilder builder = new CertExpiryBuilder(item);_visitables.get("certExpirys").remove(builder); this.certExpirys.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromCertExpirys(Predicate<CertExpiryBuilder> predicate) {
    if (certExpirys == null) return (A) this;
    final Iterator<CertExpiryBuilder> each = certExpirys.iterator();
    final List visitables = _visitables.get("certExpirys");
    while (each.hasNext()) {
      CertExpiryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<CertExpiry> buildCertExpirys() {
    return this.certExpirys != null ? build(certExpirys) : null;
  }
  
  public CertExpiry buildCertExpiry(int index) {
    return this.certExpirys.get(index).build();
  }
  
  public CertExpiry buildFirstCertExpiry() {
    return this.certExpirys.get(0).build();
  }
  
  public CertExpiry buildLastCertExpiry() {
    return this.certExpirys.get(certExpirys.size() - 1).build();
  }
  
  public CertExpiry buildMatchingCertExpiry(Predicate<CertExpiryBuilder> predicate) {
      for (CertExpiryBuilder item : certExpirys) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCertExpiry(Predicate<CertExpiryBuilder> predicate) {
      for (CertExpiryBuilder item : certExpirys) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCertExpirys(List<CertExpiry> certExpirys) {
    if (this.certExpirys != null) {
      this._visitables.get("certExpirys").clear();
    }
    if (certExpirys != null) {
        this.certExpirys = new ArrayList();
        for (CertExpiry item : certExpirys) {
          this.addToCertExpirys(item);
        }
    } else {
      this.certExpirys = null;
    }
    return (A) this;
  }
  
  public A withCertExpirys(io.fabric8.openshift.api.model.machineconfiguration.v1.CertExpiry... certExpirys) {
    if (this.certExpirys != null) {
        this.certExpirys.clear();
        _visitables.remove("certExpirys");
    }
    if (certExpirys != null) {
      for (CertExpiry item : certExpirys) {
        this.addToCertExpirys(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasCertExpirys() {
    return this.certExpirys != null && !this.certExpirys.isEmpty();
  }
  
  public A addNewCertExpiry(String bundle,String expiry,String subject) {
    return (A)addToCertExpirys(new CertExpiry(bundle, expiry, subject));
  }
  
  public CertExpirysNested<A> addNewCertExpiry() {
    return new CertExpirysNested(-1, null);
  }
  
  public CertExpirysNested<A> addNewCertExpiryLike(CertExpiry item) {
    return new CertExpirysNested(-1, item);
  }
  
  public CertExpirysNested<A> setNewCertExpiryLike(int index,CertExpiry item) {
    return new CertExpirysNested(index, item);
  }
  
  public CertExpirysNested<A> editCertExpiry(int index) {
    if (certExpirys.size() <= index) throw new RuntimeException("Can't edit certExpirys. Index exceeds size.");
    return setNewCertExpiryLike(index, buildCertExpiry(index));
  }
  
  public CertExpirysNested<A> editFirstCertExpiry() {
    if (certExpirys.size() == 0) throw new RuntimeException("Can't edit first certExpirys. The list is empty.");
    return setNewCertExpiryLike(0, buildCertExpiry(0));
  }
  
  public CertExpirysNested<A> editLastCertExpiry() {
    int index = certExpirys.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last certExpirys. The list is empty.");
    return setNewCertExpiryLike(index, buildCertExpiry(index));
  }
  
  public CertExpirysNested<A> editMatchingCertExpiry(Predicate<CertExpiryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<certExpirys.size();i++) { 
    if (predicate.test(certExpirys.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching certExpirys. No match found.");
    return setNewCertExpiryLike(index, buildCertExpiry(index));
  }
  
  public A addToConditions(int index,MachineConfigPoolCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachineConfigPoolConditionBuilder>();}
    MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,MachineConfigPoolCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachineConfigPoolConditionBuilder>();}
    MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachineConfigPoolConditionBuilder>();}
    for (MachineConfigPoolCondition item : items) {MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<MachineConfigPoolCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachineConfigPoolConditionBuilder>();}
    for (MachineConfigPoolCondition item : items) {MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolCondition... items) {
    if (this.conditions == null) return (A)this;
    for (MachineConfigPoolCondition item : items) {MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<MachineConfigPoolCondition> items) {
    if (this.conditions == null) return (A)this;
    for (MachineConfigPoolCondition item : items) {MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<MachineConfigPoolConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<MachineConfigPoolConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      MachineConfigPoolConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MachineConfigPoolCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public MachineConfigPoolCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public MachineConfigPoolCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public MachineConfigPoolCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public MachineConfigPoolCondition buildMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate) {
      for (MachineConfigPoolConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate) {
      for (MachineConfigPoolConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<MachineConfigPoolCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (MachineConfigPoolCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolCondition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (MachineConfigPoolCondition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new MachineConfigPoolCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(MachineConfigPoolCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,MachineConfigPoolCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public MachineConfigPoolStatusConfiguration buildConfiguration() {
    return this.configuration != null ? this.configuration.build() : null;
  }
  
  public A withConfiguration(MachineConfigPoolStatusConfiguration configuration) {
    this._visitables.remove("configuration");
    if (configuration != null) {
        this.configuration = new MachineConfigPoolStatusConfigurationBuilder(configuration);
        this._visitables.get("configuration").add(this.configuration);
    } else {
        this.configuration = null;
        this._visitables.get("configuration").remove(this.configuration);
    }
    return (A) this;
  }
  
  public boolean hasConfiguration() {
    return this.configuration != null;
  }
  
  public ConfigurationNested<A> withNewConfiguration() {
    return new ConfigurationNested(null);
  }
  
  public ConfigurationNested<A> withNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
    return new ConfigurationNested(item);
  }
  
  public ConfigurationNested<A> editConfiguration() {
    return withNewConfigurationLike(java.util.Optional.ofNullable(buildConfiguration()).orElse(null));
  }
  
  public ConfigurationNested<A> editOrNewConfiguration() {
    return withNewConfigurationLike(java.util.Optional.ofNullable(buildConfiguration()).orElse(new MachineConfigPoolStatusConfigurationBuilder().build()));
  }
  
  public ConfigurationNested<A> editOrNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
    return withNewConfigurationLike(java.util.Optional.ofNullable(buildConfiguration()).orElse(item));
  }
  
  public Integer getDegradedMachineCount() {
    return this.degradedMachineCount;
  }
  
  public A withDegradedMachineCount(Integer degradedMachineCount) {
    this.degradedMachineCount = degradedMachineCount;
    return (A) this;
  }
  
  public boolean hasDegradedMachineCount() {
    return this.degradedMachineCount != null;
  }
  
  public Integer getMachineCount() {
    return this.machineCount;
  }
  
  public A withMachineCount(Integer machineCount) {
    this.machineCount = machineCount;
    return (A) this;
  }
  
  public boolean hasMachineCount() {
    return this.machineCount != null;
  }
  
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration = observedGeneration;
    return (A) this;
  }
  
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  public A addToPoolSynchronizersStatus(int index,PoolSynchronizerStatus item) {
    if (this.poolSynchronizersStatus == null) {this.poolSynchronizersStatus = new ArrayList<PoolSynchronizerStatusBuilder>();}
    PoolSynchronizerStatusBuilder builder = new PoolSynchronizerStatusBuilder(item);
    if (index < 0 || index >= poolSynchronizersStatus.size()) { _visitables.get("poolSynchronizersStatus").add(builder); poolSynchronizersStatus.add(builder); } else { _visitables.get("poolSynchronizersStatus").add(index, builder); poolSynchronizersStatus.add(index, builder);}
    return (A)this;
  }
  
  public A setToPoolSynchronizersStatus(int index,PoolSynchronizerStatus item) {
    if (this.poolSynchronizersStatus == null) {this.poolSynchronizersStatus = new ArrayList<PoolSynchronizerStatusBuilder>();}
    PoolSynchronizerStatusBuilder builder = new PoolSynchronizerStatusBuilder(item);
    if (index < 0 || index >= poolSynchronizersStatus.size()) { _visitables.get("poolSynchronizersStatus").add(builder); poolSynchronizersStatus.add(builder); } else { _visitables.get("poolSynchronizersStatus").set(index, builder); poolSynchronizersStatus.set(index, builder);}
    return (A)this;
  }
  
  public A addToPoolSynchronizersStatus(io.fabric8.openshift.api.model.machineconfiguration.v1.PoolSynchronizerStatus... items) {
    if (this.poolSynchronizersStatus == null) {this.poolSynchronizersStatus = new ArrayList<PoolSynchronizerStatusBuilder>();}
    for (PoolSynchronizerStatus item : items) {PoolSynchronizerStatusBuilder builder = new PoolSynchronizerStatusBuilder(item);_visitables.get("poolSynchronizersStatus").add(builder);this.poolSynchronizersStatus.add(builder);} return (A)this;
  }
  
  public A addAllToPoolSynchronizersStatus(Collection<PoolSynchronizerStatus> items) {
    if (this.poolSynchronizersStatus == null) {this.poolSynchronizersStatus = new ArrayList<PoolSynchronizerStatusBuilder>();}
    for (PoolSynchronizerStatus item : items) {PoolSynchronizerStatusBuilder builder = new PoolSynchronizerStatusBuilder(item);_visitables.get("poolSynchronizersStatus").add(builder);this.poolSynchronizersStatus.add(builder);} return (A)this;
  }
  
  public A removeFromPoolSynchronizersStatus(io.fabric8.openshift.api.model.machineconfiguration.v1.PoolSynchronizerStatus... items) {
    if (this.poolSynchronizersStatus == null) return (A)this;
    for (PoolSynchronizerStatus item : items) {PoolSynchronizerStatusBuilder builder = new PoolSynchronizerStatusBuilder(item);_visitables.get("poolSynchronizersStatus").remove(builder); this.poolSynchronizersStatus.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPoolSynchronizersStatus(Collection<PoolSynchronizerStatus> items) {
    if (this.poolSynchronizersStatus == null) return (A)this;
    for (PoolSynchronizerStatus item : items) {PoolSynchronizerStatusBuilder builder = new PoolSynchronizerStatusBuilder(item);_visitables.get("poolSynchronizersStatus").remove(builder); this.poolSynchronizersStatus.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPoolSynchronizersStatus(Predicate<PoolSynchronizerStatusBuilder> predicate) {
    if (poolSynchronizersStatus == null) return (A) this;
    final Iterator<PoolSynchronizerStatusBuilder> each = poolSynchronizersStatus.iterator();
    final List visitables = _visitables.get("poolSynchronizersStatus");
    while (each.hasNext()) {
      PoolSynchronizerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PoolSynchronizerStatus> buildPoolSynchronizersStatus() {
    return this.poolSynchronizersStatus != null ? build(poolSynchronizersStatus) : null;
  }
  
  public PoolSynchronizerStatus buildPoolSynchronizersStatus(int index) {
    return this.poolSynchronizersStatus.get(index).build();
  }
  
  public PoolSynchronizerStatus buildFirstPoolSynchronizersStatus() {
    return this.poolSynchronizersStatus.get(0).build();
  }
  
  public PoolSynchronizerStatus buildLastPoolSynchronizersStatus() {
    return this.poolSynchronizersStatus.get(poolSynchronizersStatus.size() - 1).build();
  }
  
  public PoolSynchronizerStatus buildMatchingPoolSynchronizersStatus(Predicate<PoolSynchronizerStatusBuilder> predicate) {
      for (PoolSynchronizerStatusBuilder item : poolSynchronizersStatus) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPoolSynchronizersStatus(Predicate<PoolSynchronizerStatusBuilder> predicate) {
      for (PoolSynchronizerStatusBuilder item : poolSynchronizersStatus) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPoolSynchronizersStatus(List<PoolSynchronizerStatus> poolSynchronizersStatus) {
    if (this.poolSynchronizersStatus != null) {
      this._visitables.get("poolSynchronizersStatus").clear();
    }
    if (poolSynchronizersStatus != null) {
        this.poolSynchronizersStatus = new ArrayList();
        for (PoolSynchronizerStatus item : poolSynchronizersStatus) {
          this.addToPoolSynchronizersStatus(item);
        }
    } else {
      this.poolSynchronizersStatus = null;
    }
    return (A) this;
  }
  
  public A withPoolSynchronizersStatus(io.fabric8.openshift.api.model.machineconfiguration.v1.PoolSynchronizerStatus... poolSynchronizersStatus) {
    if (this.poolSynchronizersStatus != null) {
        this.poolSynchronizersStatus.clear();
        _visitables.remove("poolSynchronizersStatus");
    }
    if (poolSynchronizersStatus != null) {
      for (PoolSynchronizerStatus item : poolSynchronizersStatus) {
        this.addToPoolSynchronizersStatus(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPoolSynchronizersStatus() {
    return this.poolSynchronizersStatus != null && !this.poolSynchronizersStatus.isEmpty();
  }
  
  public PoolSynchronizersStatusNested<A> addNewPoolSynchronizersStatus() {
    return new PoolSynchronizersStatusNested(-1, null);
  }
  
  public PoolSynchronizersStatusNested<A> addNewPoolSynchronizersStatusLike(PoolSynchronizerStatus item) {
    return new PoolSynchronizersStatusNested(-1, item);
  }
  
  public PoolSynchronizersStatusNested<A> setNewPoolSynchronizersStatusLike(int index,PoolSynchronizerStatus item) {
    return new PoolSynchronizersStatusNested(index, item);
  }
  
  public PoolSynchronizersStatusNested<A> editPoolSynchronizersStatus(int index) {
    if (poolSynchronizersStatus.size() <= index) throw new RuntimeException("Can't edit poolSynchronizersStatus. Index exceeds size.");
    return setNewPoolSynchronizersStatusLike(index, buildPoolSynchronizersStatus(index));
  }
  
  public PoolSynchronizersStatusNested<A> editFirstPoolSynchronizersStatus() {
    if (poolSynchronizersStatus.size() == 0) throw new RuntimeException("Can't edit first poolSynchronizersStatus. The list is empty.");
    return setNewPoolSynchronizersStatusLike(0, buildPoolSynchronizersStatus(0));
  }
  
  public PoolSynchronizersStatusNested<A> editLastPoolSynchronizersStatus() {
    int index = poolSynchronizersStatus.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last poolSynchronizersStatus. The list is empty.");
    return setNewPoolSynchronizersStatusLike(index, buildPoolSynchronizersStatus(index));
  }
  
  public PoolSynchronizersStatusNested<A> editMatchingPoolSynchronizersStatus(Predicate<PoolSynchronizerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<poolSynchronizersStatus.size();i++) { 
    if (predicate.test(poolSynchronizersStatus.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching poolSynchronizersStatus. No match found.");
    return setNewPoolSynchronizersStatusLike(index, buildPoolSynchronizersStatus(index));
  }
  
  public Integer getReadyMachineCount() {
    return this.readyMachineCount;
  }
  
  public A withReadyMachineCount(Integer readyMachineCount) {
    this.readyMachineCount = readyMachineCount;
    return (A) this;
  }
  
  public boolean hasReadyMachineCount() {
    return this.readyMachineCount != null;
  }
  
  public Integer getUnavailableMachineCount() {
    return this.unavailableMachineCount;
  }
  
  public A withUnavailableMachineCount(Integer unavailableMachineCount) {
    this.unavailableMachineCount = unavailableMachineCount;
    return (A) this;
  }
  
  public boolean hasUnavailableMachineCount() {
    return this.unavailableMachineCount != null;
  }
  
  public Integer getUpdatedMachineCount() {
    return this.updatedMachineCount;
  }
  
  public A withUpdatedMachineCount(Integer updatedMachineCount) {
    this.updatedMachineCount = updatedMachineCount;
    return (A) this;
  }
  
  public boolean hasUpdatedMachineCount() {
    return this.updatedMachineCount != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineConfigPoolStatusFluent that = (MachineConfigPoolStatusFluent) o;
    if (!java.util.Objects.equals(certExpirys, that.certExpirys)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(configuration, that.configuration)) return false;
    if (!java.util.Objects.equals(degradedMachineCount, that.degradedMachineCount)) return false;
    if (!java.util.Objects.equals(machineCount, that.machineCount)) return false;
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;
    if (!java.util.Objects.equals(poolSynchronizersStatus, that.poolSynchronizersStatus)) return false;
    if (!java.util.Objects.equals(readyMachineCount, that.readyMachineCount)) return false;
    if (!java.util.Objects.equals(unavailableMachineCount, that.unavailableMachineCount)) return false;
    if (!java.util.Objects.equals(updatedMachineCount, that.updatedMachineCount)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(certExpirys,  conditions,  configuration,  degradedMachineCount,  machineCount,  observedGeneration,  poolSynchronizersStatus,  readyMachineCount,  unavailableMachineCount,  updatedMachineCount,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (certExpirys != null && !certExpirys.isEmpty()) { sb.append("certExpirys:"); sb.append(certExpirys + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (configuration != null) { sb.append("configuration:"); sb.append(configuration + ","); }
    if (degradedMachineCount != null) { sb.append("degradedMachineCount:"); sb.append(degradedMachineCount + ","); }
    if (machineCount != null) { sb.append("machineCount:"); sb.append(machineCount + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (poolSynchronizersStatus != null && !poolSynchronizersStatus.isEmpty()) { sb.append("poolSynchronizersStatus:"); sb.append(poolSynchronizersStatus + ","); }
    if (readyMachineCount != null) { sb.append("readyMachineCount:"); sb.append(readyMachineCount + ","); }
    if (unavailableMachineCount != null) { sb.append("unavailableMachineCount:"); sb.append(unavailableMachineCount + ","); }
    if (updatedMachineCount != null) { sb.append("updatedMachineCount:"); sb.append(updatedMachineCount + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CertExpirysNested<N> extends CertExpiryFluent<CertExpirysNested<N>> implements Nested<N>{
    CertExpirysNested(int index,CertExpiry item) {
      this.index = index;
      this.builder = new CertExpiryBuilder(this, item);
    }
    CertExpiryBuilder builder;
    int index;
    
    public N and() {
      return (N) MachineConfigPoolStatusFluent.this.setToCertExpirys(index,builder.build());
    }
    
    public N endCertExpiry() {
      return and();
    }
    
  
  }
  public class ConditionsNested<N> extends MachineConfigPoolConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,MachineConfigPoolCondition item) {
      this.index = index;
      this.builder = new MachineConfigPoolConditionBuilder(this, item);
    }
    MachineConfigPoolConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) MachineConfigPoolStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class ConfigurationNested<N> extends MachineConfigPoolStatusConfigurationFluent<ConfigurationNested<N>> implements Nested<N>{
    ConfigurationNested(MachineConfigPoolStatusConfiguration item) {
      this.builder = new MachineConfigPoolStatusConfigurationBuilder(this, item);
    }
    MachineConfigPoolStatusConfigurationBuilder builder;
    
    public N and() {
      return (N) MachineConfigPoolStatusFluent.this.withConfiguration(builder.build());
    }
    
    public N endConfiguration() {
      return and();
    }
    
  
  }
  public class PoolSynchronizersStatusNested<N> extends PoolSynchronizerStatusFluent<PoolSynchronizersStatusNested<N>> implements Nested<N>{
    PoolSynchronizersStatusNested(int index,PoolSynchronizerStatus item) {
      this.index = index;
      this.builder = new PoolSynchronizerStatusBuilder(this, item);
    }
    PoolSynchronizerStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) MachineConfigPoolStatusFluent.this.setToPoolSynchronizersStatus(index,builder.build());
    }
    
    public N endPoolSynchronizersStatus() {
      return and();
    }
    
  
  }

}