package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineConfigNodeStatusPinnedImageSetFluent<A extends MachineConfigNodeStatusPinnedImageSetFluent<A>> extends BaseFluent<A>{
  public MachineConfigNodeStatusPinnedImageSetFluent() {
  }
  
  public MachineConfigNodeStatusPinnedImageSetFluent(MachineConfigNodeStatusPinnedImageSet instance) {
    this.copyInstance(instance);
  }
  private Integer currentGeneration;
  private Integer desiredGeneration;
  private Integer lastFailedGeneration;
  private List<String> lastFailedGenerationErrors = new ArrayList<String>();
  private String name;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineConfigNodeStatusPinnedImageSet instance) {
    instance = (instance != null ? instance : new MachineConfigNodeStatusPinnedImageSet());
    if (instance != null) {
          this.withCurrentGeneration(instance.getCurrentGeneration());
          this.withDesiredGeneration(instance.getDesiredGeneration());
          this.withLastFailedGeneration(instance.getLastFailedGeneration());
          this.withLastFailedGenerationErrors(instance.getLastFailedGenerationErrors());
          this.withName(instance.getName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getCurrentGeneration() {
    return this.currentGeneration;
  }
  
  public A withCurrentGeneration(Integer currentGeneration) {
    this.currentGeneration = currentGeneration;
    return (A) this;
  }
  
  public boolean hasCurrentGeneration() {
    return this.currentGeneration != null;
  }
  
  public Integer getDesiredGeneration() {
    return this.desiredGeneration;
  }
  
  public A withDesiredGeneration(Integer desiredGeneration) {
    this.desiredGeneration = desiredGeneration;
    return (A) this;
  }
  
  public boolean hasDesiredGeneration() {
    return this.desiredGeneration != null;
  }
  
  public Integer getLastFailedGeneration() {
    return this.lastFailedGeneration;
  }
  
  public A withLastFailedGeneration(Integer lastFailedGeneration) {
    this.lastFailedGeneration = lastFailedGeneration;
    return (A) this;
  }
  
  public boolean hasLastFailedGeneration() {
    return this.lastFailedGeneration != null;
  }
  
  public A addToLastFailedGenerationErrors(int index,String item) {
    if (this.lastFailedGenerationErrors == null) {this.lastFailedGenerationErrors = new ArrayList<String>();}
    this.lastFailedGenerationErrors.add(index, item);
    return (A)this;
  }
  
  public A setToLastFailedGenerationErrors(int index,String item) {
    if (this.lastFailedGenerationErrors == null) {this.lastFailedGenerationErrors = new ArrayList<String>();}
    this.lastFailedGenerationErrors.set(index, item); return (A)this;
  }
  
  public A addToLastFailedGenerationErrors(java.lang.String... items) {
    if (this.lastFailedGenerationErrors == null) {this.lastFailedGenerationErrors = new ArrayList<String>();}
    for (String item : items) {this.lastFailedGenerationErrors.add(item);} return (A)this;
  }
  
  public A addAllToLastFailedGenerationErrors(Collection<String> items) {
    if (this.lastFailedGenerationErrors == null) {this.lastFailedGenerationErrors = new ArrayList<String>();}
    for (String item : items) {this.lastFailedGenerationErrors.add(item);} return (A)this;
  }
  
  public A removeFromLastFailedGenerationErrors(java.lang.String... items) {
    if (this.lastFailedGenerationErrors == null) return (A)this;
    for (String item : items) { this.lastFailedGenerationErrors.remove(item);} return (A)this;
  }
  
  public A removeAllFromLastFailedGenerationErrors(Collection<String> items) {
    if (this.lastFailedGenerationErrors == null) return (A)this;
    for (String item : items) { this.lastFailedGenerationErrors.remove(item);} return (A)this;
  }
  
  public List<String> getLastFailedGenerationErrors() {
    return this.lastFailedGenerationErrors;
  }
  
  public String getLastFailedGenerationError(int index) {
    return this.lastFailedGenerationErrors.get(index);
  }
  
  public String getFirstLastFailedGenerationError() {
    return this.lastFailedGenerationErrors.get(0);
  }
  
  public String getLastLastFailedGenerationError() {
    return this.lastFailedGenerationErrors.get(lastFailedGenerationErrors.size() - 1);
  }
  
  public String getMatchingLastFailedGenerationError(Predicate<String> predicate) {
      for (String item : lastFailedGenerationErrors) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingLastFailedGenerationError(Predicate<String> predicate) {
      for (String item : lastFailedGenerationErrors) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withLastFailedGenerationErrors(List<String> lastFailedGenerationErrors) {
    if (lastFailedGenerationErrors != null) {
        this.lastFailedGenerationErrors = new ArrayList();
        for (String item : lastFailedGenerationErrors) {
          this.addToLastFailedGenerationErrors(item);
        }
    } else {
      this.lastFailedGenerationErrors = null;
    }
    return (A) this;
  }
  
  public A withLastFailedGenerationErrors(java.lang.String... lastFailedGenerationErrors) {
    if (this.lastFailedGenerationErrors != null) {
        this.lastFailedGenerationErrors.clear();
        _visitables.remove("lastFailedGenerationErrors");
    }
    if (lastFailedGenerationErrors != null) {
      for (String item : lastFailedGenerationErrors) {
        this.addToLastFailedGenerationErrors(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasLastFailedGenerationErrors() {
    return this.lastFailedGenerationErrors != null && !this.lastFailedGenerationErrors.isEmpty();
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineConfigNodeStatusPinnedImageSetFluent that = (MachineConfigNodeStatusPinnedImageSetFluent) o;
    if (!java.util.Objects.equals(currentGeneration, that.currentGeneration)) return false;
    if (!java.util.Objects.equals(desiredGeneration, that.desiredGeneration)) return false;
    if (!java.util.Objects.equals(lastFailedGeneration, that.lastFailedGeneration)) return false;
    if (!java.util.Objects.equals(lastFailedGenerationErrors, that.lastFailedGenerationErrors)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(currentGeneration,  desiredGeneration,  lastFailedGeneration,  lastFailedGenerationErrors,  name,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (currentGeneration != null) { sb.append("currentGeneration:"); sb.append(currentGeneration + ","); }
    if (desiredGeneration != null) { sb.append("desiredGeneration:"); sb.append(desiredGeneration + ","); }
    if (lastFailedGeneration != null) { sb.append("lastFailedGeneration:"); sb.append(lastFailedGeneration + ","); }
    if (lastFailedGenerationErrors != null && !lastFailedGenerationErrors.isEmpty()) { sb.append("lastFailedGenerationErrors:"); sb.append(lastFailedGenerationErrors + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}