package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineOSConfigSpecFluent<A extends MachineOSConfigSpecFluent<A>> extends BaseFluent<A>{
  public MachineOSConfigSpecFluent() {
  }
  
  public MachineOSConfigSpecFluent(MachineOSConfigSpec instance) {
    this.copyInstance(instance);
  }
  private BuildInputsBuilder buildInputs;
  private BuildOutputsBuilder buildOutputs;
  private MachineConfigPoolReferenceBuilder machineConfigPool;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineOSConfigSpec instance) {
    instance = (instance != null ? instance : new MachineOSConfigSpec());
    if (instance != null) {
          this.withBuildInputs(instance.getBuildInputs());
          this.withBuildOutputs(instance.getBuildOutputs());
          this.withMachineConfigPool(instance.getMachineConfigPool());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public BuildInputs buildBuildInputs() {
    return this.buildInputs != null ? this.buildInputs.build() : null;
  }
  
  public A withBuildInputs(BuildInputs buildInputs) {
    this._visitables.remove("buildInputs");
    if (buildInputs != null) {
        this.buildInputs = new BuildInputsBuilder(buildInputs);
        this._visitables.get("buildInputs").add(this.buildInputs);
    } else {
        this.buildInputs = null;
        this._visitables.get("buildInputs").remove(this.buildInputs);
    }
    return (A) this;
  }
  
  public boolean hasBuildInputs() {
    return this.buildInputs != null;
  }
  
  public BuildInputsNested<A> withNewBuildInputs() {
    return new BuildInputsNested(null);
  }
  
  public BuildInputsNested<A> withNewBuildInputsLike(BuildInputs item) {
    return new BuildInputsNested(item);
  }
  
  public BuildInputsNested<A> editBuildInputs() {
    return withNewBuildInputsLike(java.util.Optional.ofNullable(buildBuildInputs()).orElse(null));
  }
  
  public BuildInputsNested<A> editOrNewBuildInputs() {
    return withNewBuildInputsLike(java.util.Optional.ofNullable(buildBuildInputs()).orElse(new BuildInputsBuilder().build()));
  }
  
  public BuildInputsNested<A> editOrNewBuildInputsLike(BuildInputs item) {
    return withNewBuildInputsLike(java.util.Optional.ofNullable(buildBuildInputs()).orElse(item));
  }
  
  public BuildOutputs buildBuildOutputs() {
    return this.buildOutputs != null ? this.buildOutputs.build() : null;
  }
  
  public A withBuildOutputs(BuildOutputs buildOutputs) {
    this._visitables.remove("buildOutputs");
    if (buildOutputs != null) {
        this.buildOutputs = new BuildOutputsBuilder(buildOutputs);
        this._visitables.get("buildOutputs").add(this.buildOutputs);
    } else {
        this.buildOutputs = null;
        this._visitables.get("buildOutputs").remove(this.buildOutputs);
    }
    return (A) this;
  }
  
  public boolean hasBuildOutputs() {
    return this.buildOutputs != null;
  }
  
  public BuildOutputsNested<A> withNewBuildOutputs() {
    return new BuildOutputsNested(null);
  }
  
  public BuildOutputsNested<A> withNewBuildOutputsLike(BuildOutputs item) {
    return new BuildOutputsNested(item);
  }
  
  public BuildOutputsNested<A> editBuildOutputs() {
    return withNewBuildOutputsLike(java.util.Optional.ofNullable(buildBuildOutputs()).orElse(null));
  }
  
  public BuildOutputsNested<A> editOrNewBuildOutputs() {
    return withNewBuildOutputsLike(java.util.Optional.ofNullable(buildBuildOutputs()).orElse(new BuildOutputsBuilder().build()));
  }
  
  public BuildOutputsNested<A> editOrNewBuildOutputsLike(BuildOutputs item) {
    return withNewBuildOutputsLike(java.util.Optional.ofNullable(buildBuildOutputs()).orElse(item));
  }
  
  public MachineConfigPoolReference buildMachineConfigPool() {
    return this.machineConfigPool != null ? this.machineConfigPool.build() : null;
  }
  
  public A withMachineConfigPool(MachineConfigPoolReference machineConfigPool) {
    this._visitables.remove("machineConfigPool");
    if (machineConfigPool != null) {
        this.machineConfigPool = new MachineConfigPoolReferenceBuilder(machineConfigPool);
        this._visitables.get("machineConfigPool").add(this.machineConfigPool);
    } else {
        this.machineConfigPool = null;
        this._visitables.get("machineConfigPool").remove(this.machineConfigPool);
    }
    return (A) this;
  }
  
  public boolean hasMachineConfigPool() {
    return this.machineConfigPool != null;
  }
  
  public A withNewMachineConfigPool(String name) {
    return (A)withMachineConfigPool(new MachineConfigPoolReference(name));
  }
  
  public MachineConfigPoolNested<A> withNewMachineConfigPool() {
    return new MachineConfigPoolNested(null);
  }
  
  public MachineConfigPoolNested<A> withNewMachineConfigPoolLike(MachineConfigPoolReference item) {
    return new MachineConfigPoolNested(item);
  }
  
  public MachineConfigPoolNested<A> editMachineConfigPool() {
    return withNewMachineConfigPoolLike(java.util.Optional.ofNullable(buildMachineConfigPool()).orElse(null));
  }
  
  public MachineConfigPoolNested<A> editOrNewMachineConfigPool() {
    return withNewMachineConfigPoolLike(java.util.Optional.ofNullable(buildMachineConfigPool()).orElse(new MachineConfigPoolReferenceBuilder().build()));
  }
  
  public MachineConfigPoolNested<A> editOrNewMachineConfigPoolLike(MachineConfigPoolReference item) {
    return withNewMachineConfigPoolLike(java.util.Optional.ofNullable(buildMachineConfigPool()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineOSConfigSpecFluent that = (MachineOSConfigSpecFluent) o;
    if (!java.util.Objects.equals(buildInputs, that.buildInputs)) return false;
    if (!java.util.Objects.equals(buildOutputs, that.buildOutputs)) return false;
    if (!java.util.Objects.equals(machineConfigPool, that.machineConfigPool)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(buildInputs,  buildOutputs,  machineConfigPool,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (buildInputs != null) { sb.append("buildInputs:"); sb.append(buildInputs + ","); }
    if (buildOutputs != null) { sb.append("buildOutputs:"); sb.append(buildOutputs + ","); }
    if (machineConfigPool != null) { sb.append("machineConfigPool:"); sb.append(machineConfigPool + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BuildInputsNested<N> extends BuildInputsFluent<BuildInputsNested<N>> implements Nested<N>{
    BuildInputsNested(BuildInputs item) {
      this.builder = new BuildInputsBuilder(this, item);
    }
    BuildInputsBuilder builder;
    
    public N and() {
      return (N) MachineOSConfigSpecFluent.this.withBuildInputs(builder.build());
    }
    
    public N endBuildInputs() {
      return and();
    }
    
  
  }
  public class BuildOutputsNested<N> extends BuildOutputsFluent<BuildOutputsNested<N>> implements Nested<N>{
    BuildOutputsNested(BuildOutputs item) {
      this.builder = new BuildOutputsBuilder(this, item);
    }
    BuildOutputsBuilder builder;
    
    public N and() {
      return (N) MachineOSConfigSpecFluent.this.withBuildOutputs(builder.build());
    }
    
    public N endBuildOutputs() {
      return and();
    }
    
  
  }
  public class MachineConfigPoolNested<N> extends MachineConfigPoolReferenceFluent<MachineConfigPoolNested<N>> implements Nested<N>{
    MachineConfigPoolNested(MachineConfigPoolReference item) {
      this.builder = new MachineConfigPoolReferenceBuilder(this, item);
    }
    MachineConfigPoolReferenceBuilder builder;
    
    public N and() {
      return (N) MachineOSConfigSpecFluent.this.withMachineConfigPool(builder.build());
    }
    
    public N endMachineConfigPool() {
      return and();
    }
    
  
  }

}