package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineOSConfigStatusBuilder extends MachineOSConfigStatusFluent<MachineOSConfigStatusBuilder> implements VisitableBuilder<MachineOSConfigStatus,MachineOSConfigStatusBuilder>{
  public MachineOSConfigStatusBuilder() {
    this(new MachineOSConfigStatus());
  }
  
  public MachineOSConfigStatusBuilder(MachineOSConfigStatusFluent<?> fluent) {
    this(fluent, new MachineOSConfigStatus());
  }
  
  public MachineOSConfigStatusBuilder(MachineOSConfigStatusFluent<?> fluent,MachineOSConfigStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineOSConfigStatusBuilder(MachineOSConfigStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineOSConfigStatusFluent<?> fluent;
  
  public MachineOSConfigStatus build() {
    MachineOSConfigStatus buildable = new MachineOSConfigStatus(fluent.getConditions(),fluent.getCurrentImagePullspec(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}