package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Condition;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class APIRequestCountStatusFluentImpl<A extends io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent<A>{
  public APIRequestCountStatusFluentImpl() {
  }
  public APIRequestCountStatusFluentImpl(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withCurrentHour(instance.getCurrentHour()); 
    this.withLast24h(instance.getLast24h()); 
    this.withRemovedInRelease(instance.getRemovedInRelease()); 
    this.withRequestCount(instance.getRequestCount()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();
  private io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder currentHour;
  private java.util.List<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder> last24h =  new java.util.ArrayList<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder>();
  private java.lang.String removedInRelease;
  private java.lang.Long requestCount;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Condition> getConditions() {
    return this.conditions;
  }
  public io.fabric8.kubernetes.api.model.Condition getCondition(java.lang.Integer index) {
    return this.conditions.get(index);
  }
  public io.fabric8.kubernetes.api.model.Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public io.fabric8.kubernetes.api.model.Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.Condition getMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions) {
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildCurrentHour instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog getCurrentHour() {
    return this.currentHour!=null?this.currentHour.build():null;
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog buildCurrentHour() {
    return this.currentHour!=null?this.currentHour.build():null;
  }
  public A withCurrentHour(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog currentHour) {
    _visitables.get("currentHour").remove(this.currentHour);
    if (currentHour!=null){ this.currentHour= new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder(currentHour); _visitables.get("currentHour").add(this.currentHour);} return (A) this;
  }
  public java.lang.Boolean hasCurrentHour() {
    return this.currentHour != null;
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.CurrentHourNested<A> withNewCurrentHour() {
    return new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluentImpl.CurrentHourNestedImpl();
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.CurrentHourNested<A> withNewCurrentHourLike(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item) {
    return new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluentImpl.CurrentHourNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.CurrentHourNested<A> editCurrentHour() {
    return withNewCurrentHourLike(getCurrentHour());
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.CurrentHourNested<A> editOrNewCurrentHour() {
    return withNewCurrentHourLike(getCurrentHour() != null ? getCurrentHour(): new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder().build());
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.CurrentHourNested<A> editOrNewCurrentHourLike(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item) {
    return withNewCurrentHourLike(getCurrentHour() != null ? getCurrentHour(): item);
  }
  public A addToLast24h(java.lang.Integer index,io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item) {
    if (this.last24h == null) {this.last24h = new java.util.ArrayList<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder>();}
    io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder builder = new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder(item);_visitables.get("last24h").add(index >= 0 ? index : _visitables.get("last24h").size(), builder);this.last24h.add(index >= 0 ? index : last24h.size(), builder); return (A)this;
  }
  public A setToLast24h(java.lang.Integer index,io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item) {
    if (this.last24h == null) {this.last24h = new java.util.ArrayList<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder>();}
    io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder builder = new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder(item);
    if (index < 0 || index >= _visitables.get("last24h").size()) { _visitables.get("last24h").add(builder); } else { _visitables.get("last24h").set(index, builder);}
    if (index < 0 || index >= last24h.size()) { last24h.add(builder); } else { last24h.set(index, builder);}
     return (A)this;
  }
  public A addToLast24h(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog... items) {
    if (this.last24h == null) {this.last24h = new java.util.ArrayList<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder>();}
    for (io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item : items) {io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder builder = new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder(item);_visitables.get("last24h").add(builder);this.last24h.add(builder);} return (A)this;
  }
  public A addAllToLast24h(java.util.Collection<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog> items) {
    if (this.last24h == null) {this.last24h = new java.util.ArrayList<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder>();}
    for (io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item : items) {io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder builder = new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder(item);_visitables.get("last24h").add(builder);this.last24h.add(builder);} return (A)this;
  }
  public A removeFromLast24h(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog... items) {
    for (io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item : items) {io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder builder = new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder(item);_visitables.get("last24h").remove(builder);if (this.last24h != null) {this.last24h.remove(builder);}} return (A)this;
  }
  public A removeAllFromLast24h(java.util.Collection<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog> items) {
    for (io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item : items) {io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder builder = new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder(item);_visitables.get("last24h").remove(builder);if (this.last24h != null) {this.last24h.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromLast24h(java.util.function.Predicate<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder> predicate) {
    if (last24h == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder> each = last24h.iterator();
    final List visitables = _visitables.get("last24h");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildLast24h instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog> getLast24h() {
    return build(last24h);
  }
  public java.util.List<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog> buildLast24h() {
    return build(last24h);
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog buildLast24h(java.lang.Integer index) {
    return this.last24h.get(index).build();
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog buildFirstLast24h() {
    return this.last24h.get(0).build();
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog buildLastLast24h() {
    return this.last24h.get(last24h.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog buildMatchingLast24h(java.util.function.Predicate<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder> predicate) {
    for (io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder item: last24h) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingLast24h(java.util.function.Predicate<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder> predicate) {
    for (io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder item: last24h) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLast24h(java.util.List<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog> last24h) {
    if (this.last24h != null) { _visitables.get("last24h").removeAll(this.last24h);}
    if (last24h != null) {this.last24h = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item : last24h){this.addToLast24h(item);}} else { this.last24h = null;} return (A) this;
  }
  public A withLast24h(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog... last24h) {
    if (this.last24h != null) {this.last24h.clear();}
    if (last24h != null) {for (io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item :last24h){ this.addToLast24h(item);}} return (A) this;
  }
  public java.lang.Boolean hasLast24h() {
    return last24h != null && !last24h.isEmpty();
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.Last24hNested<A> addNewLast24h() {
    return new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluentImpl.Last24hNestedImpl();
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.Last24hNested<A> addNewLast24hLike(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item) {
    return new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluentImpl.Last24hNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.Last24hNested<A> setNewLast24hLike(java.lang.Integer index,io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item) {
    return new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluentImpl.Last24hNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.Last24hNested<A> editLast24h(java.lang.Integer index) {
    if (last24h.size() <= index) throw new RuntimeException("Can't edit last24h. Index exceeds size.");
    return setNewLast24hLike(index, buildLast24h(index));
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.Last24hNested<A> editFirstLast24h() {
    if (last24h.size() == 0) throw new RuntimeException("Can't edit first last24h. The list is empty.");
    return setNewLast24hLike(0, buildLast24h(0));
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.Last24hNested<A> editLastLast24h() {
    int index = last24h.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last last24h. The list is empty.");
    return setNewLast24hLike(index, buildLast24h(index));
  }
  public io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.Last24hNested<A> editMatchingLast24h(java.util.function.Predicate<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder> predicate) {
    int index = -1;
    for (int i=0;i<last24h.size();i++) { 
    if (predicate.test(last24h.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching last24h. No match found.");
    return setNewLast24hLike(index, buildLast24h(index));
  }
  public java.lang.String getRemovedInRelease() {
    return this.removedInRelease;
  }
  public A withRemovedInRelease(java.lang.String removedInRelease) {
    this.removedInRelease=removedInRelease; return (A) this;
  }
  public java.lang.Boolean hasRemovedInRelease() {
    return this.removedInRelease != null;
  }
  
  /**
   * Method is deprecated. use withRemovedInRelease instead.
   */
  @java.lang.Deprecated
  public A withNewRemovedInRelease(java.lang.String arg0) {
    return (A)withRemovedInRelease(new String(arg0));
  }
  public java.lang.Long getRequestCount() {
    return this.requestCount;
  }
  public A withRequestCount(java.lang.Long requestCount) {
    this.requestCount=requestCount; return (A) this;
  }
  public java.lang.Boolean hasRequestCount() {
    return this.requestCount != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    APIRequestCountStatusFluentImpl that = (APIRequestCountStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (currentHour != null ? !currentHour.equals(that.currentHour) :that.currentHour != null) return false;
    if (last24h != null ? !last24h.equals(that.last24h) :that.last24h != null) return false;
    if (removedInRelease != null ? !removedInRelease.equals(that.removedInRelease) :that.removedInRelease != null) return false;
    if (requestCount != null ? !requestCount.equals(that.requestCount) :that.requestCount != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  currentHour,  last24h,  removedInRelease,  requestCount,  additionalProperties,  super.hashCode());
  }
  public class CurrentHourNestedImpl<N> extends io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogFluentImpl<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.CurrentHourNested<N>> implements io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.CurrentHourNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CurrentHourNestedImpl(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item) {
      this.builder = new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder(this, item);
    }
    CurrentHourNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder(this);
    }
    io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder builder;
    public N and() {
      return (N) APIRequestCountStatusFluentImpl.this.withCurrentHour(builder.build());
    }
    public N endCurrentHour() {
      return and();
    }
    
  }
  public class Last24hNestedImpl<N> extends io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogFluentImpl<io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.Last24hNested<N>> implements io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluent.Last24hNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    Last24hNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder(this, item);
    }
    Last24hNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder(this);
    }
    io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) APIRequestCountStatusFluentImpl.this.setToLast24h(index,builder.build());
    }
    public N endLast24h() {
      return and();
    }
    
  }
  
}