package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import java.util.ArrayList;
import java.lang.String;
import java.lang.Double;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CPUFluentImpl<A extends io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.CPUFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.CPUFluent<A> {

    private java.lang.String arch;
    private java.lang.Double clockMegahertz;
    private java.lang.Integer count;
    private java.util.List<java.lang.String> flags = new java.util.ArrayList<java.lang.String>();
    private java.lang.String model;

    public CPUFluentImpl() {
    }

    public CPUFluentImpl(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.CPU instance) {
        this.withArch(instance.getArch()); 
        this.withClockMegahertz(instance.getClockMegahertz()); 
        this.withCount(instance.getCount()); 
        this.withFlags(instance.getFlags()); 
        this.withModel(instance.getModel()); 
    }

    public java.lang.String getArch() {
        return this.arch;
    }

    public A withArch(java.lang.String arch) {
        this.arch=arch; return (A) this;
    }

    public java.lang.Boolean hasArch() {
        return this.arch != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withArch instead.
     */
        public A withNewArch(java.lang.String arg0) {
        return (A)withArch(new String(arg0));
    }

    public java.lang.Double getClockMegahertz() {
        return this.clockMegahertz;
    }

    public A withClockMegahertz(java.lang.Double clockMegahertz) {
        this.clockMegahertz=clockMegahertz; return (A) this;
    }

    public java.lang.Boolean hasClockMegahertz() {
        return this.clockMegahertz != null;
    }

    public java.lang.Integer getCount() {
        return this.count;
    }

    public A withCount(java.lang.Integer count) {
        this.count=count; return (A) this;
    }

    public java.lang.Boolean hasCount() {
        return this.count != null;
    }

    public A addToFlags(int index,java.lang.String item) {
        if (this.flags == null) {this.flags = new java.util.ArrayList<java.lang.String>();}
        this.flags.add(index, item);
        return (A)this;
    }

    public A setToFlags(int index,java.lang.String item) {
        if (this.flags == null) {this.flags = new java.util.ArrayList<java.lang.String>();}
        this.flags.set(index, item); return (A)this;
    }

    public A addToFlags(java.lang.String... items) {
        if (this.flags == null) {this.flags = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.flags.add(item);} return (A)this;
    }

    public A addAllToFlags(java.util.Collection<java.lang.String> items) {
        if (this.flags == null) {this.flags = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.flags.add(item);} return (A)this;
    }

    public A removeFromFlags(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.flags!= null){ this.flags.remove(item);}} return (A)this;
    }

    public A removeAllFromFlags(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.flags!= null){ this.flags.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getFlags() {
        return this.flags;
    }

    public java.lang.String getFlag(int index) {
        return this.flags.get(index);
    }

    public java.lang.String getFirstFlag() {
        return this.flags.get(0);
    }

    public java.lang.String getLastFlag() {
        return this.flags.get(flags.size() - 1);
    }

    public java.lang.String getMatchingFlag(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: flags) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingFlag(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: flags) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withFlags(java.util.List<java.lang.String> flags) {
        if (this.flags != null) { _visitables.get("flags").removeAll(this.flags);}
        if (flags != null) {this.flags = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : flags){this.addToFlags(item);}} else { this.flags = null;} return (A) this;
    }

    public A withFlags(java.lang.String... flags) {
        if (this.flags != null) {this.flags.clear();}
        if (flags != null) {for (java.lang.String item :flags){ this.addToFlags(item);}} return (A) this;
    }

    public java.lang.Boolean hasFlags() {
        return flags != null && !flags.isEmpty();
    }

    public A addNewFlag(java.lang.String arg0) {
        return (A)addToFlags(new String(arg0));
    }

    public java.lang.String getModel() {
        return this.model;
    }

    public A withModel(java.lang.String model) {
        this.model=model; return (A) this;
    }

    public java.lang.Boolean hasModel() {
        return this.model != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withModel instead.
     */
        public A withNewModel(java.lang.String arg0) {
        return (A)withModel(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CPUFluentImpl that = (CPUFluentImpl) o;
        if (arch != null ? !arch.equals(that.arch) :that.arch != null) return false;
        if (clockMegahertz != null ? !clockMegahertz.equals(that.clockMegahertz) :that.clockMegahertz != null) return false;
        if (count != null ? !count.equals(that.count) :that.count != null) return false;
        if (flags != null ? !flags.equals(that.flags) :that.flags != null) return false;
        if (model != null ? !model.equals(that.model) :that.model != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(arch,  clockMegahertz,  count,  flags,  model,  super.hashCode());
    }

}
