package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RAIDConfigBuilder extends io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfigFluentImpl<io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfig,io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfigBuilder> {

    io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RAIDConfigBuilder() {
        this(true);
    }

    public RAIDConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new RAIDConfig(), validationEnabled);
    }

    public RAIDConfigBuilder(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public RAIDConfigBuilder(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RAIDConfig(), validationEnabled);
    }

    public RAIDConfigBuilder(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfigFluent<?> fluent,io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfig instance) {
        this(fluent, instance, true);
    }

    public RAIDConfigBuilder(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfigFluent<?> fluent,io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHardwareRAIDVolumes(instance.getHardwareRAIDVolumes()); 
        fluent.withSoftwareRAIDVolumes(instance.getSoftwareRAIDVolumes()); 
        this.validationEnabled = validationEnabled; 
    }

    public RAIDConfigBuilder(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfig instance) {
        this(instance,true);
    }

    public RAIDConfigBuilder(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withHardwareRAIDVolumes(instance.getHardwareRAIDVolumes()); 
        this.withSoftwareRAIDVolumes(instance.getSoftwareRAIDVolumes()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfig build() {
        RAIDConfig buildable = new RAIDConfig(fluent.getHardwareRAIDVolumes(),fluent.getSoftwareRAIDVolumes());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RAIDConfigBuilder that = (RAIDConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
