/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKI;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKIBuilder;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKIFluentImpl;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKIList;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKIListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class OperatorPKIListFluentImpl<A extends OperatorPKIListFluent<A>>
extends BaseFluent<A>
implements OperatorPKIListFluent<A> {
    private String apiVersion;
    private List<OperatorPKIBuilder> items = new ArrayList<OperatorPKIBuilder>();
    private String kind;
    private ListMeta metadata;

    public OperatorPKIListFluentImpl() {
    }

    public OperatorPKIListFluentImpl(OperatorPKIList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(int index, OperatorPKI item) {
        if (this.items == null) {
            this.items = new ArrayList<OperatorPKIBuilder>();
        }
        OperatorPKIBuilder builder = new OperatorPKIBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, OperatorPKI item) {
        if (this.items == null) {
            this.items = new ArrayList<OperatorPKIBuilder>();
        }
        OperatorPKIBuilder builder = new OperatorPKIBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(OperatorPKI ... items) {
        if (this.items == null) {
            this.items = new ArrayList<OperatorPKIBuilder>();
        }
        for (OperatorPKI item : items) {
            OperatorPKIBuilder builder = new OperatorPKIBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<OperatorPKI> items) {
        if (this.items == null) {
            this.items = new ArrayList<OperatorPKIBuilder>();
        }
        for (OperatorPKI item : items) {
            OperatorPKIBuilder builder = new OperatorPKIBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(OperatorPKI ... items) {
        for (OperatorPKI item : items) {
            OperatorPKIBuilder builder = new OperatorPKIBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<OperatorPKI> items) {
        for (OperatorPKI item : items) {
            OperatorPKIBuilder builder = new OperatorPKIBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<OperatorPKIBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<OperatorPKIBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            OperatorPKIBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<OperatorPKI> getItems() {
        return OperatorPKIListFluentImpl.build(this.items);
    }

    @Override
    public List<OperatorPKI> buildItems() {
        return OperatorPKIListFluentImpl.build(this.items);
    }

    @Override
    public OperatorPKI buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public OperatorPKI buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public OperatorPKI buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public OperatorPKI buildMatchingItem(Predicate<OperatorPKIBuilder> predicate) {
        for (OperatorPKIBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<OperatorPKIBuilder> predicate) {
        for (OperatorPKIBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<OperatorPKI> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<OperatorPKIBuilder>();
            for (OperatorPKI item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(OperatorPKI ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (OperatorPKI item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public OperatorPKIListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public OperatorPKIListFluent.ItemsNested<A> addNewItemLike(OperatorPKI item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public OperatorPKIListFluent.ItemsNested<A> setNewItemLike(int index, OperatorPKI item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public OperatorPKIListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public OperatorPKIListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public OperatorPKIListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public OperatorPKIListFluent.ItemsNested<A> editMatchingItem(Predicate<OperatorPKIBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorPKIListFluentImpl that = (OperatorPKIListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends OperatorPKIFluentImpl<OperatorPKIListFluent.ItemsNested<N>>
    implements OperatorPKIListFluent.ItemsNested<N>,
    Nested<N> {
        private final OperatorPKIBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, OperatorPKI item) {
            this.index = index;
            this.builder = new OperatorPKIBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new OperatorPKIBuilder(this);
        }

        @Override
        public N and() {
            return (N)OperatorPKIListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

