package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class ImageRegistrySpecFluentImpl<A extends io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent<A>{
  public ImageRegistrySpecFluentImpl() {
  }
  public ImageRegistrySpecFluentImpl(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpec instance) {
    this.withAffinity(instance.getAffinity()); 
    this.withDefaultRoute(instance.getDefaultRoute()); 
    this.withDisableRedirect(instance.getDisableRedirect()); 
    this.withHttpSecret(instance.getHttpSecret()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withLogging(instance.getLogging()); 
    this.withManagementState(instance.getManagementState()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withProxy(instance.getProxy()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRequests(instance.getRequests()); 
    this.withResources(instance.getResources()); 
    this.withRolloutStrategy(instance.getRolloutStrategy()); 
    this.withRoutes(instance.getRoutes()); 
    this.withStorage(instance.getStorage()); 
    this.withTolerations(instance.getTolerations()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
  }
  private io.fabric8.kubernetes.api.model.Affinity affinity;
  private java.lang.Boolean defaultRoute;
  private java.lang.Boolean disableRedirect;
  private java.lang.String httpSecret;
  private java.lang.String logLevel;
  private java.lang.Long logging;
  private java.lang.String managementState;
  private java.util.Map<java.lang.String,java.lang.String> nodeSelector;
  private java.util.Map<java.lang.String,java.lang.Object> observedConfig;
  private java.lang.String operatorLogLevel;
  private io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxyBuilder proxy;
  private java.lang.Boolean readOnly;
  private java.lang.Integer replicas;
  private io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequestsBuilder requests;
  private io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder resources;
  private java.lang.String rolloutStrategy;
  private java.util.List<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder> routes =  new java.util.ArrayList<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder>();
  private io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageBuilder storage;
  private java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();
  private java.util.Map<java.lang.String,java.lang.Object> unsupportedConfigOverrides;
  public io.fabric8.kubernetes.api.model.Affinity getAffinity() {
    return this.affinity;
  }
  public A withAffinity(io.fabric8.kubernetes.api.model.Affinity affinity) {
    this.affinity=affinity; return (A) this;
  }
  public java.lang.Boolean hasAffinity() {
    return this.affinity != null;
  }
  public java.lang.Boolean getDefaultRoute() {
    return this.defaultRoute;
  }
  public A withDefaultRoute(java.lang.Boolean defaultRoute) {
    this.defaultRoute=defaultRoute; return (A) this;
  }
  public java.lang.Boolean hasDefaultRoute() {
    return this.defaultRoute != null;
  }
  public java.lang.Boolean getDisableRedirect() {
    return this.disableRedirect;
  }
  public A withDisableRedirect(java.lang.Boolean disableRedirect) {
    this.disableRedirect=disableRedirect; return (A) this;
  }
  public java.lang.Boolean hasDisableRedirect() {
    return this.disableRedirect != null;
  }
  public java.lang.String getHttpSecret() {
    return this.httpSecret;
  }
  public A withHttpSecret(java.lang.String httpSecret) {
    this.httpSecret=httpSecret; return (A) this;
  }
  public java.lang.Boolean hasHttpSecret() {
    return this.httpSecret != null;
  }
  
  /**
   * Method is deprecated. use withHttpSecret instead.
   */
  @java.lang.Deprecated
  public A withNewHttpSecret(java.lang.String arg0) {
    return (A)withHttpSecret(new String(arg0));
  }
  public java.lang.String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(java.lang.String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public java.lang.Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  /**
   * Method is deprecated. use withLogLevel instead.
   */
  @java.lang.Deprecated
  public A withNewLogLevel(java.lang.String arg0) {
    return (A)withLogLevel(new String(arg0));
  }
  public java.lang.Long getLogging() {
    return this.logging;
  }
  public A withLogging(java.lang.Long logging) {
    this.logging=logging; return (A) this;
  }
  public java.lang.Boolean hasLogging() {
    return this.logging != null;
  }
  public java.lang.String getManagementState() {
    return this.managementState;
  }
  public A withManagementState(java.lang.String managementState) {
    this.managementState=managementState; return (A) this;
  }
  public java.lang.Boolean hasManagementState() {
    return this.managementState != null;
  }
  
  /**
   * Method is deprecated. use withManagementState instead.
   */
  @java.lang.Deprecated
  public A withNewManagementState(java.lang.String arg0) {
    return (A)withManagementState(new String(arg0));
  }
  public A addToNodeSelector(java.lang.String key,java.lang.String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(java.lang.String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(java.util.Map<java.lang.String,java.lang.String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(nodeSelector);} return (A) this;
  }
  public java.lang.Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public A addToObservedConfig(java.lang.String key,java.lang.Object value) {
    if(this.observedConfig == null && key != null && value != null) { this.observedConfig = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.observedConfig.put(key, value);} return (A)this;
  }
  public A addToObservedConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.observedConfig == null && map != null) { this.observedConfig = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.observedConfig.putAll(map);} return (A)this;
  }
  public A removeFromObservedConfig(java.lang.String key) {
    if(this.observedConfig == null) { return (A) this; }
    if(key != null && this.observedConfig != null) {this.observedConfig.remove(key);} return (A)this;
  }
  public A removeFromObservedConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.observedConfig == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.observedConfig != null){this.observedConfig.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getObservedConfig() {
    return this.observedConfig;
  }
  public <K,V>A withObservedConfig(java.util.Map<java.lang.String,java.lang.Object> observedConfig) {
    if (observedConfig == null) { this.observedConfig =  null;} else {this.observedConfig = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(observedConfig);} return (A) this;
  }
  public java.lang.Boolean hasObservedConfig() {
    return this.observedConfig != null;
  }
  public java.lang.String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  public A withOperatorLogLevel(java.lang.String operatorLogLevel) {
    this.operatorLogLevel=operatorLogLevel; return (A) this;
  }
  public java.lang.Boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  
  /**
   * Method is deprecated. use withOperatorLogLevel instead.
   */
  @java.lang.Deprecated
  public A withNewOperatorLogLevel(java.lang.String arg0) {
    return (A)withOperatorLogLevel(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildProxy instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxy getProxy() {
    return this.proxy!=null?this.proxy.build():null;
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxy buildProxy() {
    return this.proxy!=null?this.proxy.build():null;
  }
  public A withProxy(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxy proxy) {
    _visitables.get("proxy").remove(this.proxy);
    if (proxy!=null){ this.proxy= new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxyBuilder(proxy); _visitables.get("proxy").add(this.proxy);} return (A) this;
  }
  public java.lang.Boolean hasProxy() {
    return this.proxy != null;
  }
  public A withNewProxy(java.lang.String http,java.lang.String https,java.lang.String noProxy) {
    return (A)withProxy(new ImageRegistryConfigProxy(http, https, noProxy));
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ProxyNested<A> withNewProxy() {
    return new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluentImpl.ProxyNestedImpl();
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ProxyNested<A> withNewProxyLike(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxy item) {
    return new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluentImpl.ProxyNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ProxyNested<A> editProxy() {
    return withNewProxyLike(getProxy());
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ProxyNested<A> editOrNewProxy() {
    return withNewProxyLike(getProxy() != null ? getProxy(): new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxyBuilder().build());
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ProxyNested<A> editOrNewProxyLike(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxy item) {
    return withNewProxyLike(getProxy() != null ? getProxy(): item);
  }
  public java.lang.Boolean getReadOnly() {
    return this.readOnly;
  }
  public A withReadOnly(java.lang.Boolean readOnly) {
    this.readOnly=readOnly; return (A) this;
  }
  public java.lang.Boolean hasReadOnly() {
    return this.readOnly != null;
  }
  public java.lang.Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(java.lang.Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public java.lang.Boolean hasReplicas() {
    return this.replicas != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRequests instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequests getRequests() {
    return this.requests!=null?this.requests.build():null;
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequests buildRequests() {
    return this.requests!=null?this.requests.build():null;
  }
  public A withRequests(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequests requests) {
    _visitables.get("requests").remove(this.requests);
    if (requests!=null){ this.requests= new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequestsBuilder(requests); _visitables.get("requests").add(this.requests);} return (A) this;
  }
  public java.lang.Boolean hasRequests() {
    return this.requests != null;
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RequestsNested<A> withNewRequests() {
    return new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluentImpl.RequestsNestedImpl();
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RequestsNested<A> withNewRequestsLike(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequests item) {
    return new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluentImpl.RequestsNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RequestsNested<A> editRequests() {
    return withNewRequestsLike(getRequests());
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RequestsNested<A> editOrNewRequests() {
    return withNewRequestsLike(getRequests() != null ? getRequests(): new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequestsBuilder().build());
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RequestsNested<A> editOrNewRequestsLike(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequests item) {
    return withNewRequestsLike(getRequests() != null ? getRequests(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
    return this.resources!=null?this.resources.build():null;
  }
  public io.fabric8.kubernetes.api.model.ResourceRequirements buildResources() {
    return this.resources!=null?this.resources.build():null;
  }
  public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
  }
  public java.lang.Boolean hasResources() {
    return this.resources != null;
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ResourcesNested<A> withNewResources() {
    return new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluentImpl.ResourcesNestedImpl();
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ResourcesNested<A> withNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
    return new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluentImpl.ResourcesNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder().build());
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ResourcesNested<A> editOrNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public java.lang.String getRolloutStrategy() {
    return this.rolloutStrategy;
  }
  public A withRolloutStrategy(java.lang.String rolloutStrategy) {
    this.rolloutStrategy=rolloutStrategy; return (A) this;
  }
  public java.lang.Boolean hasRolloutStrategy() {
    return this.rolloutStrategy != null;
  }
  
  /**
   * Method is deprecated. use withRolloutStrategy instead.
   */
  @java.lang.Deprecated
  public A withNewRolloutStrategy(java.lang.String arg0) {
    return (A)withRolloutStrategy(new String(arg0));
  }
  public A addToRoutes(java.lang.Integer index,io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute item) {
    if (this.routes == null) {this.routes = new java.util.ArrayList<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder>();}
    io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder(item);_visitables.get("routes").add(index >= 0 ? index : _visitables.get("routes").size(), builder);this.routes.add(index >= 0 ? index : routes.size(), builder); return (A)this;
  }
  public A setToRoutes(java.lang.Integer index,io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute item) {
    if (this.routes == null) {this.routes = new java.util.ArrayList<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder>();}
    io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder(item);
    if (index < 0 || index >= _visitables.get("routes").size()) { _visitables.get("routes").add(builder); } else { _visitables.get("routes").set(index, builder);}
    if (index < 0 || index >= routes.size()) { routes.add(builder); } else { routes.set(index, builder);}
     return (A)this;
  }
  public A addToRoutes(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute... items) {
    if (this.routes == null) {this.routes = new java.util.ArrayList<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder>();}
    for (io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute item : items) {io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder(item);_visitables.get("routes").add(builder);this.routes.add(builder);} return (A)this;
  }
  public A addAllToRoutes(java.util.Collection<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute> items) {
    if (this.routes == null) {this.routes = new java.util.ArrayList<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder>();}
    for (io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute item : items) {io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder(item);_visitables.get("routes").add(builder);this.routes.add(builder);} return (A)this;
  }
  public A removeFromRoutes(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute... items) {
    for (io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute item : items) {io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder(item);_visitables.get("routes").remove(builder);if (this.routes != null) {this.routes.remove(builder);}} return (A)this;
  }
  public A removeAllFromRoutes(java.util.Collection<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute> items) {
    for (io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute item : items) {io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder(item);_visitables.get("routes").remove(builder);if (this.routes != null) {this.routes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRoutes(java.util.function.Predicate<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder> predicate) {
    if (routes == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder> each = routes.iterator();
    final List visitables = _visitables.get("routes");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRoutes instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute> getRoutes() {
    return build(routes);
  }
  public java.util.List<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute> buildRoutes() {
    return build(routes);
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute buildRoute(java.lang.Integer index) {
    return this.routes.get(index).build();
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute buildFirstRoute() {
    return this.routes.get(0).build();
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute buildLastRoute() {
    return this.routes.get(routes.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute buildMatchingRoute(java.util.function.Predicate<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder> predicate) {
    for (io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder item: routes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingRoute(java.util.function.Predicate<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder> predicate) {
    for (io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder item: routes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRoutes(java.util.List<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute> routes) {
    if (this.routes != null) { _visitables.get("routes").removeAll(this.routes);}
    if (routes != null) {this.routes = new java.util.ArrayList<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder>(); for (io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute item : routes){this.addToRoutes(item);}} else { this.routes = null;} return (A) this;
  }
  public A withRoutes(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute... routes) {
    if (this.routes != null) {this.routes.clear();}
    if (routes != null) {for (io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute item :routes){ this.addToRoutes(item);}} return (A) this;
  }
  public java.lang.Boolean hasRoutes() {
    return routes != null && !routes.isEmpty();
  }
  public A addNewRoute(java.lang.String hostname,java.lang.String name,java.lang.String secretName) {
    return (A)addToRoutes(new ImageRegistryConfigRoute(hostname, name, secretName));
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RoutesNested<A> addNewRoute() {
    return new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluentImpl.RoutesNestedImpl();
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RoutesNested<A> addNewRouteLike(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute item) {
    return new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluentImpl.RoutesNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RoutesNested<A> setNewRouteLike(java.lang.Integer index,io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute item) {
    return new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluentImpl.RoutesNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RoutesNested<A> editRoute(java.lang.Integer index) {
    if (routes.size() <= index) throw new RuntimeException("Can't edit routes. Index exceeds size.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RoutesNested<A> editFirstRoute() {
    if (routes.size() == 0) throw new RuntimeException("Can't edit first routes. The list is empty.");
    return setNewRouteLike(0, buildRoute(0));
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RoutesNested<A> editLastRoute() {
    int index = routes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last routes. The list is empty.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RoutesNested<A> editMatchingRoute(java.util.function.Predicate<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder> predicate) {
    int index = -1;
    for (int i=0;i<routes.size();i++) { 
    if (predicate.test(routes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching routes. No match found.");
    return setNewRouteLike(index, buildRoute(index));
  }
  
  /**
   * This method has been deprecated, please use method buildStorage instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorage getStorage() {
    return this.storage!=null?this.storage.build():null;
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorage buildStorage() {
    return this.storage!=null?this.storage.build():null;
  }
  public A withStorage(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorage storage) {
    _visitables.get("storage").remove(this.storage);
    if (storage!=null){ this.storage= new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageBuilder(storage); _visitables.get("storage").add(this.storage);} return (A) this;
  }
  public java.lang.Boolean hasStorage() {
    return this.storage != null;
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.StorageNested<A> withNewStorage() {
    return new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluentImpl.StorageNestedImpl();
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.StorageNested<A> withNewStorageLike(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorage item) {
    return new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluentImpl.StorageNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.StorageNested<A> editStorage() {
    return withNewStorageLike(getStorage());
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.StorageNested<A> editOrNewStorage() {
    return withNewStorageLike(getStorage() != null ? getStorage(): new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageBuilder().build());
  }
  public io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.StorageNested<A> editOrNewStorageLike(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorage item) {
    return withNewStorageLike(getStorage() != null ? getStorage(): item);
  }
  public A addToTolerations(java.lang.Integer index,io.fabric8.kubernetes.api.model.Toleration item) {
    if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  public A setToTolerations(java.lang.Integer index,io.fabric8.kubernetes.api.model.Toleration item) {
    if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
    for (io.fabric8.kubernetes.api.model.Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A addAllToTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
    for (io.fabric8.kubernetes.api.model.Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    for (io.fabric8.kubernetes.api.model.Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public A removeAllFromTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items) {
    for (io.fabric8.kubernetes.api.model.Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Toleration> getTolerations() {
    return this.tolerations;
  }
  public io.fabric8.kubernetes.api.model.Toleration getToleration(java.lang.Integer index) {
    return this.tolerations.get(index);
  }
  public io.fabric8.kubernetes.api.model.Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  public io.fabric8.kubernetes.api.model.Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.Toleration getMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate) {
    for (io.fabric8.kubernetes.api.model.Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate) {
    for (io.fabric8.kubernetes.api.model.Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations) {
    if (tolerations != null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>(); for (io.fabric8.kubernetes.api.model.Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear();}
    if (tolerations != null) {for (io.fabric8.kubernetes.api.model.Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public java.lang.Boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(java.lang.String effect,java.lang.String key,java.lang.String operator,java.lang.Long tolerationSeconds,java.lang.String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public A addToUnsupportedConfigOverrides(java.lang.String key,java.lang.Object value) {
    if(this.unsupportedConfigOverrides == null && key != null && value != null) { this.unsupportedConfigOverrides = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.unsupportedConfigOverrides.put(key, value);} return (A)this;
  }
  public A addToUnsupportedConfigOverrides(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.unsupportedConfigOverrides == null && map != null) { this.unsupportedConfigOverrides = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.unsupportedConfigOverrides.putAll(map);} return (A)this;
  }
  public A removeFromUnsupportedConfigOverrides(java.lang.String key) {
    if(this.unsupportedConfigOverrides == null) { return (A) this; }
    if(key != null && this.unsupportedConfigOverrides != null) {this.unsupportedConfigOverrides.remove(key);} return (A)this;
  }
  public A removeFromUnsupportedConfigOverrides(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.unsupportedConfigOverrides == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.unsupportedConfigOverrides != null){this.unsupportedConfigOverrides.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides;
  }
  public <K,V>A withUnsupportedConfigOverrides(java.util.Map<java.lang.String,java.lang.Object> unsupportedConfigOverrides) {
    if (unsupportedConfigOverrides == null) { this.unsupportedConfigOverrides =  null;} else {this.unsupportedConfigOverrides = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(unsupportedConfigOverrides);} return (A) this;
  }
  public java.lang.Boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageRegistrySpecFluentImpl that = (ImageRegistrySpecFluentImpl) o;
    if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
    if (defaultRoute != null ? !defaultRoute.equals(that.defaultRoute) :that.defaultRoute != null) return false;
    if (disableRedirect != null ? !disableRedirect.equals(that.disableRedirect) :that.disableRedirect != null) return false;
    if (httpSecret != null ? !httpSecret.equals(that.httpSecret) :that.httpSecret != null) return false;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
    if (managementState != null ? !managementState.equals(that.managementState) :that.managementState != null) return false;
    if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
    if (observedConfig != null ? !observedConfig.equals(that.observedConfig) :that.observedConfig != null) return false;
    if (operatorLogLevel != null ? !operatorLogLevel.equals(that.operatorLogLevel) :that.operatorLogLevel != null) return false;
    if (proxy != null ? !proxy.equals(that.proxy) :that.proxy != null) return false;
    if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (requests != null ? !requests.equals(that.requests) :that.requests != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (rolloutStrategy != null ? !rolloutStrategy.equals(that.rolloutStrategy) :that.rolloutStrategy != null) return false;
    if (routes != null ? !routes.equals(that.routes) :that.routes != null) return false;
    if (storage != null ? !storage.equals(that.storage) :that.storage != null) return false;
    if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
    if (unsupportedConfigOverrides != null ? !unsupportedConfigOverrides.equals(that.unsupportedConfigOverrides) :that.unsupportedConfigOverrides != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(affinity,  defaultRoute,  disableRedirect,  httpSecret,  logLevel,  logging,  managementState,  nodeSelector,  observedConfig,  operatorLogLevel,  proxy,  readOnly,  replicas,  requests,  resources,  rolloutStrategy,  routes,  storage,  tolerations,  unsupportedConfigOverrides,  super.hashCode());
  }
  public class ProxyNestedImpl<N> extends io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxyFluentImpl<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ProxyNested<N>> implements io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ProxyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProxyNestedImpl(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxy item) {
      this.builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxyBuilder(this, item);
    }
    ProxyNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxyBuilder(this);
    }
    io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxyBuilder builder;
    public N and() {
      return (N) ImageRegistrySpecFluentImpl.this.withProxy(builder.build());
    }
    public N endProxy() {
      return and();
    }
    
  }
  public class RequestsNestedImpl<N> extends io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequestsFluentImpl<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RequestsNested<N>> implements io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RequestsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RequestsNestedImpl(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequests item) {
      this.builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequestsBuilder(this, item);
    }
    RequestsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequestsBuilder(this);
    }
    io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequestsBuilder builder;
    public N and() {
      return (N) ImageRegistrySpecFluentImpl.this.withRequests(builder.build());
    }
    public N endRequests() {
      return and();
    }
    
  }
  public class ResourcesNestedImpl<N> extends io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ResourcesNested<N>> implements io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ResourcesNestedImpl(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
      this.builder = new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder builder;
    public N and() {
      return (N) ImageRegistrySpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  public class RoutesNestedImpl<N> extends io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteFluentImpl<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RoutesNested<N>> implements io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.RoutesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoutesNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder(this, item);
    }
    RoutesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder(this);
    }
    io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ImageRegistrySpecFluentImpl.this.setToRoutes(index,builder.build());
    }
    public N endRoute() {
      return and();
    }
    
  }
  public class StorageNestedImpl<N> extends io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageFluentImpl<io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.StorageNested<N>> implements io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent.StorageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    StorageNestedImpl(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorage item) {
      this.builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageBuilder(this, item);
    }
    StorageNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageBuilder(this);
    }
    io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageBuilder builder;
    public N and() {
      return (N) ImageRegistrySpecFluentImpl.this.withStorage(builder.build());
    }
    public N endStorage() {
      return and();
    }
    
  }
  
}