/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.L4RedirectRule;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.L4RedirectRuleBuilder;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.L4RedirectRuleFluentImpl;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.RedirectConfig;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.RedirectConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RedirectConfigFluentImpl<A extends RedirectConfigFluent<A>>
extends BaseFluent<A>
implements RedirectConfigFluent<A> {
    private String fallbackIP;
    private ArrayList<L4RedirectRuleBuilder> redirectRules = new ArrayList();
    private Map<String, Object> additionalProperties;

    public RedirectConfigFluentImpl() {
    }

    public RedirectConfigFluentImpl(RedirectConfig instance) {
        this.withFallbackIP(instance.getFallbackIP());
        this.withRedirectRules(instance.getRedirectRules());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getFallbackIP() {
        return this.fallbackIP;
    }

    @Override
    public A withFallbackIP(String fallbackIP) {
        this.fallbackIP = fallbackIP;
        return (A)this;
    }

    @Override
    public Boolean hasFallbackIP() {
        return this.fallbackIP != null;
    }

    @Override
    public A addToRedirectRules(Integer index, L4RedirectRule item) {
        if (this.redirectRules == null) {
            this.redirectRules = new ArrayList();
        }
        L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
        this._visitables.get((Object)"redirectRules").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"redirectRules").size(), builder);
        this.redirectRules.add(index >= 0 ? index.intValue() : this.redirectRules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRedirectRules(Integer index, L4RedirectRule item) {
        if (this.redirectRules == null) {
            this.redirectRules = new ArrayList();
        }
        L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"redirectRules").size()) {
            this._visitables.get((Object)"redirectRules").add(builder);
        } else {
            this._visitables.get((Object)"redirectRules").set(index, builder);
        }
        if (index < 0 || index >= this.redirectRules.size()) {
            this.redirectRules.add(builder);
        } else {
            this.redirectRules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRedirectRules(L4RedirectRule ... items) {
        if (this.redirectRules == null) {
            this.redirectRules = new ArrayList();
        }
        for (L4RedirectRule item : items) {
            L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
            this._visitables.get((Object)"redirectRules").add(builder);
            this.redirectRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRedirectRules(Collection<L4RedirectRule> items) {
        if (this.redirectRules == null) {
            this.redirectRules = new ArrayList();
        }
        for (L4RedirectRule item : items) {
            L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
            this._visitables.get((Object)"redirectRules").add(builder);
            this.redirectRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRedirectRules(L4RedirectRule ... items) {
        for (L4RedirectRule item : items) {
            L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
            this._visitables.get((Object)"redirectRules").remove(builder);
            if (this.redirectRules == null) continue;
            this.redirectRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRedirectRules(Collection<L4RedirectRule> items) {
        for (L4RedirectRule item : items) {
            L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
            this._visitables.get((Object)"redirectRules").remove(builder);
            if (this.redirectRules == null) continue;
            this.redirectRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRedirectRules(Predicate<L4RedirectRuleBuilder> predicate) {
        if (this.redirectRules == null) {
            return (A)this;
        }
        Iterator<L4RedirectRuleBuilder> each = this.redirectRules.iterator();
        List visitables = this._visitables.get((Object)"redirectRules");
        while (each.hasNext()) {
            L4RedirectRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<L4RedirectRule> getRedirectRules() {
        return this.redirectRules != null ? RedirectConfigFluentImpl.build(this.redirectRules) : null;
    }

    @Override
    public List<L4RedirectRule> buildRedirectRules() {
        return this.redirectRules != null ? RedirectConfigFluentImpl.build(this.redirectRules) : null;
    }

    @Override
    public L4RedirectRule buildRedirectRule(Integer index) {
        return this.redirectRules.get(index).build();
    }

    @Override
    public L4RedirectRule buildFirstRedirectRule() {
        return this.redirectRules.get(0).build();
    }

    @Override
    public L4RedirectRule buildLastRedirectRule() {
        return this.redirectRules.get(this.redirectRules.size() - 1).build();
    }

    @Override
    public L4RedirectRule buildMatchingRedirectRule(Predicate<L4RedirectRuleBuilder> predicate) {
        for (L4RedirectRuleBuilder item : this.redirectRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRedirectRule(Predicate<L4RedirectRuleBuilder> predicate) {
        for (L4RedirectRuleBuilder item : this.redirectRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRedirectRules(List<L4RedirectRule> redirectRules) {
        if (this.redirectRules != null) {
            this._visitables.get((Object)"redirectRules").removeAll(this.redirectRules);
        }
        if (redirectRules != null) {
            this.redirectRules = new ArrayList();
            for (L4RedirectRule item : redirectRules) {
                this.addToRedirectRules(item);
            }
        } else {
            this.redirectRules = null;
        }
        return (A)this;
    }

    @Override
    public A withRedirectRules(L4RedirectRule ... redirectRules) {
        if (this.redirectRules != null) {
            this.redirectRules.clear();
        }
        if (redirectRules != null) {
            for (L4RedirectRule item : redirectRules) {
                this.addToRedirectRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRedirectRules() {
        return this.redirectRules != null && !this.redirectRules.isEmpty();
    }

    @Override
    public A addNewRedirectRule(String destinationIP, Integer port, String protocol, Integer targetPort) {
        return this.addToRedirectRules(new L4RedirectRule(destinationIP, port, protocol, targetPort));
    }

    @Override
    public RedirectConfigFluent.RedirectRulesNested<A> addNewRedirectRule() {
        return new RedirectRulesNestedImpl();
    }

    @Override
    public RedirectConfigFluent.RedirectRulesNested<A> addNewRedirectRuleLike(L4RedirectRule item) {
        return new RedirectRulesNestedImpl(-1, item);
    }

    @Override
    public RedirectConfigFluent.RedirectRulesNested<A> setNewRedirectRuleLike(Integer index, L4RedirectRule item) {
        return new RedirectRulesNestedImpl(index, item);
    }

    @Override
    public RedirectConfigFluent.RedirectRulesNested<A> editRedirectRule(Integer index) {
        if (this.redirectRules.size() <= index) {
            throw new RuntimeException("Can't edit redirectRules. Index exceeds size.");
        }
        return this.setNewRedirectRuleLike(index, this.buildRedirectRule(index));
    }

    @Override
    public RedirectConfigFluent.RedirectRulesNested<A> editFirstRedirectRule() {
        if (this.redirectRules.size() == 0) {
            throw new RuntimeException("Can't edit first redirectRules. The list is empty.");
        }
        return this.setNewRedirectRuleLike(0, this.buildRedirectRule(0));
    }

    @Override
    public RedirectConfigFluent.RedirectRulesNested<A> editLastRedirectRule() {
        int index = this.redirectRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last redirectRules. The list is empty.");
        }
        return this.setNewRedirectRuleLike(index, this.buildRedirectRule(index));
    }

    @Override
    public RedirectConfigFluent.RedirectRulesNested<A> editMatchingRedirectRule(Predicate<L4RedirectRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.redirectRules.size(); ++i) {
            if (!predicate.test(this.redirectRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching redirectRules. No match found.");
        }
        return this.setNewRedirectRuleLike(index, this.buildRedirectRule(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedirectConfigFluentImpl that = (RedirectConfigFluentImpl)o;
        if (this.fallbackIP != null ? !this.fallbackIP.equals(that.fallbackIP) : that.fallbackIP != null) {
            return false;
        }
        if (this.redirectRules != null ? !this.redirectRules.equals(that.redirectRules) : that.redirectRules != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.fallbackIP, this.redirectRules, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fallbackIP != null) {
            sb.append("fallbackIP:");
            sb.append(this.fallbackIP + ",");
        }
        if (this.redirectRules != null && !this.redirectRules.isEmpty()) {
            sb.append("redirectRules:");
            sb.append(this.redirectRules + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class RedirectRulesNestedImpl<N>
    extends L4RedirectRuleFluentImpl<RedirectConfigFluent.RedirectRulesNested<N>>
    implements RedirectConfigFluent.RedirectRulesNested<N>,
    Nested<N> {
        L4RedirectRuleBuilder builder;
        Integer index;

        RedirectRulesNestedImpl(Integer index, L4RedirectRule item) {
            this.index = index;
            this.builder = new L4RedirectRuleBuilder(this, item);
        }

        RedirectRulesNestedImpl() {
            this.index = -1;
            this.builder = new L4RedirectRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)RedirectConfigFluentImpl.this.setToRedirectRules(this.index, this.builder.build());
        }

        @Override
        public N endRedirectRule() {
            return this.and();
        }
    }
}

