package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageRegistryConfigProxyBuilder extends ImageRegistryConfigProxyFluent<ImageRegistryConfigProxyBuilder> implements VisitableBuilder<ImageRegistryConfigProxy,ImageRegistryConfigProxyBuilder>{
  public ImageRegistryConfigProxyBuilder() {
    this(new ImageRegistryConfigProxy());
  }
  
  public ImageRegistryConfigProxyBuilder(ImageRegistryConfigProxyFluent<?> fluent) {
    this(fluent, new ImageRegistryConfigProxy());
  }
  
  public ImageRegistryConfigProxyBuilder(ImageRegistryConfigProxyFluent<?> fluent,ImageRegistryConfigProxy instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageRegistryConfigProxyBuilder(ImageRegistryConfigProxy instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageRegistryConfigProxyFluent<?> fluent;
  
  public ImageRegistryConfigProxy build() {
    ImageRegistryConfigProxy buildable = new ImageRegistryConfigProxy(fluent.getHttp(),fluent.getHttps(),fluent.getNoProxy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}