package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageRegistryConfigStorageGCSBuilder extends ImageRegistryConfigStorageGCSFluent<ImageRegistryConfigStorageGCSBuilder> implements VisitableBuilder<ImageRegistryConfigStorageGCS,ImageRegistryConfigStorageGCSBuilder>{
  public ImageRegistryConfigStorageGCSBuilder() {
    this(new ImageRegistryConfigStorageGCS());
  }
  
  public ImageRegistryConfigStorageGCSBuilder(ImageRegistryConfigStorageGCSFluent<?> fluent) {
    this(fluent, new ImageRegistryConfigStorageGCS());
  }
  
  public ImageRegistryConfigStorageGCSBuilder(ImageRegistryConfigStorageGCSFluent<?> fluent,ImageRegistryConfigStorageGCS instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageRegistryConfigStorageGCSBuilder(ImageRegistryConfigStorageGCS instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageRegistryConfigStorageGCSFluent<?> fluent;
  
  public ImageRegistryConfigStorageGCS build() {
    ImageRegistryConfigStorageGCS buildable = new ImageRegistryConfigStorageGCS(fluent.getBucket(),fluent.getKeyID(),fluent.getProjectID(),fluent.getRegion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}