package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CredentialsRequestSpecFluentImpl<A extends CredentialsRequestSpecFluent<A>> extends BaseFluent<A> implements CredentialsRequestSpecFluent<A>{
  public CredentialsRequestSpecFluentImpl() {
  }
  public CredentialsRequestSpecFluentImpl(CredentialsRequestSpec instance) {
    this.withProviderSpec(instance.getProviderSpec()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withServiceAccountNames(instance.getServiceAccountNames()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Map<String,Object> providerSpec;
  private ObjectReferenceBuilder secretRef;
  private List<String> serviceAccountNames = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToProviderSpec(String key,Object value) {
    if(this.providerSpec == null && key != null && value != null) { this.providerSpec = new LinkedHashMap(); }
    if(key != null && value != null) {this.providerSpec.put(key, value);} return (A)this;
  }
  public A addToProviderSpec(Map<String,Object> map) {
    if(this.providerSpec == null && map != null) { this.providerSpec = new LinkedHashMap(); }
    if(map != null) { this.providerSpec.putAll(map);} return (A)this;
  }
  public A removeFromProviderSpec(String key) {
    if(this.providerSpec == null) { return (A) this; }
    if(key != null && this.providerSpec != null) {this.providerSpec.remove(key);} return (A)this;
  }
  public A removeFromProviderSpec(Map<String,Object> map) {
    if(this.providerSpec == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.providerSpec != null){this.providerSpec.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getProviderSpec() {
    return this.providerSpec;
  }
  public <K,V>A withProviderSpec(Map<String,Object> providerSpec) {
    if (providerSpec == null) { this.providerSpec =  null;} else {this.providerSpec = new LinkedHashMap(providerSpec);} return (A) this;
  }
  public Boolean hasProviderSpec() {
    return this.providerSpec != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public ObjectReference buildSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public A withSecretRef(ObjectReference secretRef) {
    _visitables.get("secretRef").remove(this.secretRef);
    if (secretRef!=null){ this.secretRef= new ObjectReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} else { this.secretRef = null; _visitables.get("secretRef").remove(this.secretRef); } return (A) this;
  }
  public Boolean hasSecretRef() {
    return this.secretRef != null;
  }
  public CredentialsRequestSpecFluent.SecretRefNested<A> withNewSecretRef() {
    return new CredentialsRequestSpecFluentImpl.SecretRefNestedImpl();
  }
  public CredentialsRequestSpecFluent.SecretRefNested<A> withNewSecretRefLike(ObjectReference item) {
    return new CredentialsRequestSpecFluentImpl.SecretRefNestedImpl(item);
  }
  public CredentialsRequestSpecFluent.SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(getSecretRef());
  }
  public CredentialsRequestSpecFluent.SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new ObjectReferenceBuilder().build());
  }
  public CredentialsRequestSpecFluent.SecretRefNested<A> editOrNewSecretRefLike(ObjectReference item) {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
  }
  public A addToServiceAccountNames(Integer index,String item) {
    if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
    this.serviceAccountNames.add(index, item);
    return (A)this;
  }
  public A setToServiceAccountNames(Integer index,String item) {
    if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
    this.serviceAccountNames.set(index, item); return (A)this;
  }
  public A addToServiceAccountNames(java.lang.String... items) {
    if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
    for (String item : items) {this.serviceAccountNames.add(item);} return (A)this;
  }
  public A addAllToServiceAccountNames(Collection<String> items) {
    if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
    for (String item : items) {this.serviceAccountNames.add(item);} return (A)this;
  }
  public A removeFromServiceAccountNames(java.lang.String... items) {
    for (String item : items) {if (this.serviceAccountNames!= null){ this.serviceAccountNames.remove(item);}} return (A)this;
  }
  public A removeAllFromServiceAccountNames(Collection<String> items) {
    for (String item : items) {if (this.serviceAccountNames!= null){ this.serviceAccountNames.remove(item);}} return (A)this;
  }
  public List<String> getServiceAccountNames() {
    return this.serviceAccountNames;
  }
  public String getServiceAccountName(Integer index) {
    return this.serviceAccountNames.get(index);
  }
  public String getFirstServiceAccountName() {
    return this.serviceAccountNames.get(0);
  }
  public String getLastServiceAccountName() {
    return this.serviceAccountNames.get(serviceAccountNames.size() - 1);
  }
  public String getMatchingServiceAccountName(Predicate<String> predicate) {
    for (String item: serviceAccountNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingServiceAccountName(Predicate<String> predicate) {
    for (String item: serviceAccountNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceAccountNames(List<String> serviceAccountNames) {
    if (serviceAccountNames != null) {this.serviceAccountNames = new ArrayList(); for (String item : serviceAccountNames){this.addToServiceAccountNames(item);}} else { this.serviceAccountNames = null;} return (A) this;
  }
  public A withServiceAccountNames(java.lang.String... serviceAccountNames) {
    if (this.serviceAccountNames != null) {this.serviceAccountNames.clear();}
    if (serviceAccountNames != null) {for (String item :serviceAccountNames){ this.addToServiceAccountNames(item);}} return (A) this;
  }
  public Boolean hasServiceAccountNames() {
    return serviceAccountNames != null && !serviceAccountNames.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CredentialsRequestSpecFluentImpl that = (CredentialsRequestSpecFluentImpl) o;
    if (providerSpec != null ? !providerSpec.equals(that.providerSpec) :that.providerSpec != null) return false;
    if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
    if (serviceAccountNames != null ? !serviceAccountNames.equals(that.serviceAccountNames) :that.serviceAccountNames != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(providerSpec,  secretRef,  serviceAccountNames,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (providerSpec != null && !providerSpec.isEmpty()) { sb.append("providerSpec:"); sb.append(providerSpec + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (serviceAccountNames != null && !serviceAccountNames.isEmpty()) { sb.append("serviceAccountNames:"); sb.append(serviceAccountNames + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SecretRefNestedImpl<N> extends ObjectReferenceFluentImpl<CredentialsRequestSpecFluent.SecretRefNested<N>> implements CredentialsRequestSpecFluent.SecretRefNested<N>,Nested<N>{
    SecretRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    SecretRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) CredentialsRequestSpecFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef() {
      return and();
    }
    
  }
  
}