package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CredentialsRequestStatusFluentImpl<A extends CredentialsRequestStatusFluent<A>> extends BaseFluent<A> implements CredentialsRequestStatusFluent<A>{
  public CredentialsRequestStatusFluentImpl() {
  }
  public CredentialsRequestStatusFluentImpl(CredentialsRequestStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withLastSyncCloudCredsSecretResourceVersion(instance.getLastSyncCloudCredsSecretResourceVersion()); 
    this.withLastSyncGeneration(instance.getLastSyncGeneration()); 
    this.withLastSyncTimestamp(instance.getLastSyncTimestamp()); 
    this.withProviderStatus(instance.getProviderStatus()); 
    this.withProvisioned(instance.getProvisioned()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<CredentialsRequestConditionBuilder> conditions = new ArrayList<CredentialsRequestConditionBuilder>();
  private String lastSyncCloudCredsSecretResourceVersion;
  private Long lastSyncGeneration;
  private String lastSyncTimestamp;
  private Map<String,Object> providerStatus;
  private Boolean provisioned;
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,CredentialsRequestCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<CredentialsRequestConditionBuilder>();}
    CredentialsRequestConditionBuilder builder = new CredentialsRequestConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,CredentialsRequestCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<CredentialsRequestConditionBuilder>();}
    CredentialsRequestConditionBuilder builder = new CredentialsRequestConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<CredentialsRequestConditionBuilder>();}
    for (CredentialsRequestCondition item : items) {CredentialsRequestConditionBuilder builder = new CredentialsRequestConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<CredentialsRequestCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<CredentialsRequestConditionBuilder>();}
    for (CredentialsRequestCondition item : items) {CredentialsRequestConditionBuilder builder = new CredentialsRequestConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestCondition... items) {
    for (CredentialsRequestCondition item : items) {CredentialsRequestConditionBuilder builder = new CredentialsRequestConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<CredentialsRequestCondition> items) {
    for (CredentialsRequestCondition item : items) {CredentialsRequestConditionBuilder builder = new CredentialsRequestConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<CredentialsRequestConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<CredentialsRequestConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      CredentialsRequestConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CredentialsRequestCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<CredentialsRequestCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public CredentialsRequestCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public CredentialsRequestCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public CredentialsRequestCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public CredentialsRequestCondition buildMatchingCondition(Predicate<CredentialsRequestConditionBuilder> predicate) {
    for (CredentialsRequestConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<CredentialsRequestConditionBuilder> predicate) {
    for (CredentialsRequestConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<CredentialsRequestCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (CredentialsRequestCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (CredentialsRequestCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public CredentialsRequestStatusFluent.ConditionsNested<A> addNewCondition() {
    return new CredentialsRequestStatusFluentImpl.ConditionsNestedImpl();
  }
  public CredentialsRequestStatusFluent.ConditionsNested<A> addNewConditionLike(CredentialsRequestCondition item) {
    return new CredentialsRequestStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public CredentialsRequestStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,CredentialsRequestCondition item) {
    return new CredentialsRequestStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public CredentialsRequestStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public CredentialsRequestStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public CredentialsRequestStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public CredentialsRequestStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<CredentialsRequestConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getLastSyncCloudCredsSecretResourceVersion() {
    return this.lastSyncCloudCredsSecretResourceVersion;
  }
  public A withLastSyncCloudCredsSecretResourceVersion(String lastSyncCloudCredsSecretResourceVersion) {
    this.lastSyncCloudCredsSecretResourceVersion=lastSyncCloudCredsSecretResourceVersion; return (A) this;
  }
  public Boolean hasLastSyncCloudCredsSecretResourceVersion() {
    return this.lastSyncCloudCredsSecretResourceVersion != null;
  }
  public Long getLastSyncGeneration() {
    return this.lastSyncGeneration;
  }
  public A withLastSyncGeneration(Long lastSyncGeneration) {
    this.lastSyncGeneration=lastSyncGeneration; return (A) this;
  }
  public Boolean hasLastSyncGeneration() {
    return this.lastSyncGeneration != null;
  }
  public String getLastSyncTimestamp() {
    return this.lastSyncTimestamp;
  }
  public A withLastSyncTimestamp(String lastSyncTimestamp) {
    this.lastSyncTimestamp=lastSyncTimestamp; return (A) this;
  }
  public Boolean hasLastSyncTimestamp() {
    return this.lastSyncTimestamp != null;
  }
  public A addToProviderStatus(String key,Object value) {
    if(this.providerStatus == null && key != null && value != null) { this.providerStatus = new LinkedHashMap(); }
    if(key != null && value != null) {this.providerStatus.put(key, value);} return (A)this;
  }
  public A addToProviderStatus(Map<String,Object> map) {
    if(this.providerStatus == null && map != null) { this.providerStatus = new LinkedHashMap(); }
    if(map != null) { this.providerStatus.putAll(map);} return (A)this;
  }
  public A removeFromProviderStatus(String key) {
    if(this.providerStatus == null) { return (A) this; }
    if(key != null && this.providerStatus != null) {this.providerStatus.remove(key);} return (A)this;
  }
  public A removeFromProviderStatus(Map<String,Object> map) {
    if(this.providerStatus == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.providerStatus != null){this.providerStatus.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getProviderStatus() {
    return this.providerStatus;
  }
  public <K,V>A withProviderStatus(Map<String,Object> providerStatus) {
    if (providerStatus == null) { this.providerStatus =  null;} else {this.providerStatus = new LinkedHashMap(providerStatus);} return (A) this;
  }
  public Boolean hasProviderStatus() {
    return this.providerStatus != null;
  }
  public Boolean getProvisioned() {
    return this.provisioned;
  }
  public A withProvisioned(Boolean provisioned) {
    this.provisioned=provisioned; return (A) this;
  }
  public Boolean hasProvisioned() {
    return this.provisioned != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CredentialsRequestStatusFluentImpl that = (CredentialsRequestStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (lastSyncCloudCredsSecretResourceVersion != null ? !lastSyncCloudCredsSecretResourceVersion.equals(that.lastSyncCloudCredsSecretResourceVersion) :that.lastSyncCloudCredsSecretResourceVersion != null) return false;
    if (lastSyncGeneration != null ? !lastSyncGeneration.equals(that.lastSyncGeneration) :that.lastSyncGeneration != null) return false;
    if (lastSyncTimestamp != null ? !lastSyncTimestamp.equals(that.lastSyncTimestamp) :that.lastSyncTimestamp != null) return false;
    if (providerStatus != null ? !providerStatus.equals(that.providerStatus) :that.providerStatus != null) return false;
    if (provisioned != null ? !provisioned.equals(that.provisioned) :that.provisioned != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  lastSyncCloudCredsSecretResourceVersion,  lastSyncGeneration,  lastSyncTimestamp,  providerStatus,  provisioned,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (lastSyncCloudCredsSecretResourceVersion != null) { sb.append("lastSyncCloudCredsSecretResourceVersion:"); sb.append(lastSyncCloudCredsSecretResourceVersion + ","); }
    if (lastSyncGeneration != null) { sb.append("lastSyncGeneration:"); sb.append(lastSyncGeneration + ","); }
    if (lastSyncTimestamp != null) { sb.append("lastSyncTimestamp:"); sb.append(lastSyncTimestamp + ","); }
    if (providerStatus != null && !providerStatus.isEmpty()) { sb.append("providerStatus:"); sb.append(providerStatus + ","); }
    if (provisioned != null) { sb.append("provisioned:"); sb.append(provisioned + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withProvisioned() {
    return withProvisioned(true);
  }
  class ConditionsNestedImpl<N> extends CredentialsRequestConditionFluentImpl<CredentialsRequestStatusFluent.ConditionsNested<N>> implements CredentialsRequestStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,CredentialsRequestCondition item) {
      this.index = index;
      this.builder = new CredentialsRequestConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new CredentialsRequestConditionBuilder(this);
    }
    CredentialsRequestConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) CredentialsRequestStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}