package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageRegistryConfigStorageAzureBuilder extends ImageRegistryConfigStorageAzureFluentImpl<ImageRegistryConfigStorageAzureBuilder> implements VisitableBuilder<ImageRegistryConfigStorageAzure,ImageRegistryConfigStorageAzureBuilder>{
  public ImageRegistryConfigStorageAzureBuilder() {
    this(false);
  }
  public ImageRegistryConfigStorageAzureBuilder(Boolean validationEnabled) {
    this(new ImageRegistryConfigStorageAzure(), validationEnabled);
  }
  public ImageRegistryConfigStorageAzureBuilder(ImageRegistryConfigStorageAzureFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageRegistryConfigStorageAzureBuilder(ImageRegistryConfigStorageAzureFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageRegistryConfigStorageAzure(), validationEnabled);
  }
  public ImageRegistryConfigStorageAzureBuilder(ImageRegistryConfigStorageAzureFluent<?> fluent,ImageRegistryConfigStorageAzure instance) {
    this(fluent, instance, false);
  }
  public ImageRegistryConfigStorageAzureBuilder(ImageRegistryConfigStorageAzureFluent<?> fluent,ImageRegistryConfigStorageAzure instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAccountName(instance.getAccountName()); 
    fluent.withCloudName(instance.getCloudName()); 
    fluent.withContainer(instance.getContainer()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageRegistryConfigStorageAzureBuilder(ImageRegistryConfigStorageAzure instance) {
    this(instance,false);
  }
  public ImageRegistryConfigStorageAzureBuilder(ImageRegistryConfigStorageAzure instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAccountName(instance.getAccountName()); 
    this.withCloudName(instance.getCloudName()); 
    this.withContainer(instance.getContainer()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageRegistryConfigStorageAzureFluent<?> fluent;
  Boolean validationEnabled;
  public ImageRegistryConfigStorageAzure build() {
    ImageRegistryConfigStorageAzure buildable = new ImageRegistryConfigStorageAzure(fluent.getAccountName(),fluent.getCloudName(),fluent.getContainer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}