package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageRegistryConfigStorageBuilder extends ImageRegistryConfigStorageFluentImpl<ImageRegistryConfigStorageBuilder> implements VisitableBuilder<ImageRegistryConfigStorage,ImageRegistryConfigStorageBuilder>{
  public ImageRegistryConfigStorageBuilder() {
    this(false);
  }
  public ImageRegistryConfigStorageBuilder(Boolean validationEnabled) {
    this(new ImageRegistryConfigStorage(), validationEnabled);
  }
  public ImageRegistryConfigStorageBuilder(ImageRegistryConfigStorageFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageRegistryConfigStorageBuilder(ImageRegistryConfigStorageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageRegistryConfigStorage(), validationEnabled);
  }
  public ImageRegistryConfigStorageBuilder(ImageRegistryConfigStorageFluent<?> fluent,ImageRegistryConfigStorage instance) {
    this(fluent, instance, false);
  }
  public ImageRegistryConfigStorageBuilder(ImageRegistryConfigStorageFluent<?> fluent,ImageRegistryConfigStorage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAzure(instance.getAzure()); 
    fluent.withEmptyDir(instance.getEmptyDir()); 
    fluent.withGcs(instance.getGcs()); 
    fluent.withIbmcos(instance.getIbmcos()); 
    fluent.withManagementState(instance.getManagementState()); 
    fluent.withPvc(instance.getPvc()); 
    fluent.withS3(instance.getS3()); 
    fluent.withSwift(instance.getSwift()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageRegistryConfigStorageBuilder(ImageRegistryConfigStorage instance) {
    this(instance,false);
  }
  public ImageRegistryConfigStorageBuilder(ImageRegistryConfigStorage instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAzure(instance.getAzure()); 
    this.withEmptyDir(instance.getEmptyDir()); 
    this.withGcs(instance.getGcs()); 
    this.withIbmcos(instance.getIbmcos()); 
    this.withManagementState(instance.getManagementState()); 
    this.withPvc(instance.getPvc()); 
    this.withS3(instance.getS3()); 
    this.withSwift(instance.getSwift()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageRegistryConfigStorageFluent<?> fluent;
  Boolean validationEnabled;
  public ImageRegistryConfigStorage build() {
    ImageRegistryConfigStorage buildable = new ImageRegistryConfigStorage(fluent.getAzure(),fluent.getEmptyDir(),fluent.getGcs(),fluent.getIbmcos(),fluent.getManagementState(),fluent.getPvc(),fluent.getS3(),fluent.getSwift());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}