package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageRegistryConfigStorageS3CloudFrontFluentImpl<A extends ImageRegistryConfigStorageS3CloudFrontFluent<A>> extends BaseFluent<A> implements ImageRegistryConfigStorageS3CloudFrontFluent<A>{
  public ImageRegistryConfigStorageS3CloudFrontFluentImpl() {
  }
  public ImageRegistryConfigStorageS3CloudFrontFluentImpl(ImageRegistryConfigStorageS3CloudFront instance) {
    this.withBaseURL(instance.getBaseURL()); 
    this.withDuration(instance.getDuration()); 
    this.withKeypairID(instance.getKeypairID()); 
    this.withPrivateKey(instance.getPrivateKey()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String baseURL;
  private Duration duration;
  private String keypairID;
  private SecretKeySelector privateKey;
  private Map<String,Object> additionalProperties;
  public String getBaseURL() {
    return this.baseURL;
  }
  public A withBaseURL(String baseURL) {
    this.baseURL=baseURL; return (A) this;
  }
  public Boolean hasBaseURL() {
    return this.baseURL != null;
  }
  public Duration getDuration() {
    return this.duration;
  }
  public A withDuration(Duration duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public String getKeypairID() {
    return this.keypairID;
  }
  public A withKeypairID(String keypairID) {
    this.keypairID=keypairID; return (A) this;
  }
  public Boolean hasKeypairID() {
    return this.keypairID != null;
  }
  public SecretKeySelector getPrivateKey() {
    return this.privateKey;
  }
  public A withPrivateKey(SecretKeySelector privateKey) {
    this.privateKey=privateKey; return (A) this;
  }
  public Boolean hasPrivateKey() {
    return this.privateKey != null;
  }
  public A withNewPrivateKey(String key,String name,Boolean optional) {
    return (A)withPrivateKey(new SecretKeySelector(key, name, optional));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageRegistryConfigStorageS3CloudFrontFluentImpl that = (ImageRegistryConfigStorageS3CloudFrontFluentImpl) o;
    if (baseURL != null ? !baseURL.equals(that.baseURL) :that.baseURL != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (keypairID != null ? !keypairID.equals(that.keypairID) :that.keypairID != null) return false;
    if (privateKey != null ? !privateKey.equals(that.privateKey) :that.privateKey != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(baseURL,  duration,  keypairID,  privateKey,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseURL != null) { sb.append("baseURL:"); sb.append(baseURL + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (keypairID != null) { sb.append("keypairID:"); sb.append(keypairID + ","); }
    if (privateKey != null) { sb.append("privateKey:"); sb.append(privateKey + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}