package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.GenerationStatus;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.v1.OperatorCondition;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ImageRegistryStatusFluent<A extends ImageRegistryStatusFluent<A>> extends Fluent<A>{
  public A addToConditions(Integer index,OperatorCondition item);
  public A setToConditions(Integer index,OperatorCondition item);
  public A addToConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items);
  public A addAllToConditions(Collection<OperatorCondition> items);
  public A removeFromConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items);
  public A removeAllFromConditions(Collection<OperatorCondition> items);
  public List<OperatorCondition> getConditions();
  public OperatorCondition getCondition(Integer index);
  public OperatorCondition getFirstCondition();
  public OperatorCondition getLastCondition();
  public OperatorCondition getMatchingCondition(Predicate<OperatorCondition> predicate);
  public Boolean hasMatchingCondition(Predicate<OperatorCondition> predicate);
  public A withConditions(List<OperatorCondition> conditions);
  public A withConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... conditions);
  public Boolean hasConditions();
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
  public A addToGenerations(Integer index,GenerationStatus item);
  public A setToGenerations(Integer index,GenerationStatus item);
  public A addToGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... items);
  public A addAllToGenerations(Collection<GenerationStatus> items);
  public A removeFromGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... items);
  public A removeAllFromGenerations(Collection<GenerationStatus> items);
  public List<GenerationStatus> getGenerations();
  public GenerationStatus getGeneration(Integer index);
  public GenerationStatus getFirstGeneration();
  public GenerationStatus getLastGeneration();
  public GenerationStatus getMatchingGeneration(Predicate<GenerationStatus> predicate);
  public Boolean hasMatchingGeneration(Predicate<GenerationStatus> predicate);
  public A withGenerations(List<GenerationStatus> generations);
  public A withGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... generations);
  public Boolean hasGenerations();
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public Integer getReadyReplicas();
  public A withReadyReplicas(Integer readyReplicas);
  public Boolean hasReadyReplicas();
  
  /**
   * This method has been deprecated, please use method buildStorage instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigStorage getStorage();
  public ImageRegistryConfigStorage buildStorage();
  public A withStorage(ImageRegistryConfigStorage storage);
  public Boolean hasStorage();
  public ImageRegistryStatusFluent.StorageNested<A> withNewStorage();
  public ImageRegistryStatusFluent.StorageNested<A> withNewStorageLike(ImageRegistryConfigStorage item);
  public ImageRegistryStatusFluent.StorageNested<A> editStorage();
  public ImageRegistryStatusFluent.StorageNested<A> editOrNewStorage();
  public ImageRegistryStatusFluent.StorageNested<A> editOrNewStorageLike(ImageRegistryConfigStorage item);
  public Boolean getStorageManaged();
  public A withStorageManaged(Boolean storageManaged);
  public Boolean hasStorageManaged();
  public String getVersion();
  public A withVersion(String version);
  public Boolean hasVersion();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withStorageManaged();
  public interface StorageNested<N> extends Nested<N>,ImageRegistryConfigStorageFluent<ImageRegistryStatusFluent.StorageNested<N>>{
    public N and();
    public N endStorage();
    
  }
  
}