package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressRouterStatusBuilder extends EgressRouterStatusFluentImpl<EgressRouterStatusBuilder> implements VisitableBuilder<EgressRouterStatus,EgressRouterStatusBuilder>{
  public EgressRouterStatusBuilder() {
    this(false);
  }
  public EgressRouterStatusBuilder(Boolean validationEnabled) {
    this(new EgressRouterStatus(), validationEnabled);
  }
  public EgressRouterStatusBuilder(EgressRouterStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressRouterStatusBuilder(EgressRouterStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EgressRouterStatus(), validationEnabled);
  }
  public EgressRouterStatusBuilder(EgressRouterStatusFluent<?> fluent,EgressRouterStatus instance) {
    this(fluent, instance, false);
  }
  public EgressRouterStatusBuilder(EgressRouterStatusFluent<?> fluent,EgressRouterStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EgressRouterStatusBuilder(EgressRouterStatus instance) {
    this(instance,false);
  }
  public EgressRouterStatusBuilder(EgressRouterStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  EgressRouterStatusFluent<?> fluent;
  Boolean validationEnabled;
  public EgressRouterStatus build() {
    EgressRouterStatus buildable = new EgressRouterStatus(fluent.getConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}